/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Ice.Communicator;
import Ice.Identity;
import Ice.ObjectPrx;
import Ice.Util;
import IceGrid.AdminSessionPrx;
import IceGrid.ObjectNotRegisteredException;
import IceGrid.PermissionDeniedException;
import IceGrid.QueryPrx;
import IceGrid.QueryPrxHelper;
import IceGrid.RegistryPrx;
import IceGrid.RegistryPrxHelper;
import java.util.Arrays;
import omero.internal.ClusterNodePrx;
import omero.internal.ClusterNodePrxHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface Registry {
    public QueryPrx getGridQuery();

    public AdminSessionPrx getAdminSession() throws PermissionDeniedException;

    public void addObject(ObjectPrx var1) throws Exception;

    public void removeObject(Identity var1) throws Exception;

    public boolean removeObjectSafely(Identity var1);

    public ClusterNodePrx[] lookupClusterNodes();

    public static class Impl
    implements Registry {
        private static final Log log = LogFactory.getLog(Registry.class);
        private final Communicator ic;

        public Impl(Communicator ic) {
            this.ic = ic;
        }

        public QueryPrx getGridQuery() {
            try {
                ObjectPrx objectPrx = this.ic.stringToProxy("IceGrid/Query");
                QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)objectPrx);
                return query;
            }
            catch (Exception e) {
                log.warn((Object)("Could not find IceGrid/Query: " + e));
                return null;
            }
        }

        public AdminSessionPrx getAdminSession() throws PermissionDeniedException {
            ObjectPrx objectPrx = this.ic.stringToProxy("IceGrid/Registry");
            RegistryPrx reg = RegistryPrxHelper.checkedCast((ObjectPrx)objectPrx);
            AdminSessionPrx session = reg.createAdminSession("null", "");
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObject(ObjectPrx obj) throws Exception {
            AdminSessionPrx session = this.getAdminSession();
            try {
                session.getAdmin().addObject(obj);
                log.info((Object)("Added " + this.ic.identityToString(obj.ice_getIdentity()) + " to registry"));
            }
            finally {
                session.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObject(Identity id) throws Exception {
            AdminSessionPrx session = this.getAdminSession();
            try {
                session.getAdmin().removeObject(id);
                log.info((Object)("Removed " + this.ic.identityToString(id) + " from registry"));
            }
            finally {
                session.destroy();
            }
        }

        public boolean removeObjectSafely(Identity id) {
            try {
                this.removeObject(id);
                return true;
            }
            catch (ObjectNotRegisteredException onre) {
                log.debug((Object)(Util.identityToString((Identity)id) + " not registered"));
            }
            catch (Exception e) {
                log.error((Object)("Failed to remove registry object " + Util.identityToString((Identity)id)), (Throwable)e);
            }
            return false;
        }

        public ClusterNodePrx[] lookupClusterNodes() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType("::omero::internal::ClusterNode");
                Object[] nodes = new ClusterNodePrx[candidates.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = ClusterNodePrxHelper.uncheckedCast(candidates[i]);
                }
                log.info((Object)("Found " + nodes.length + " cluster node(s) : " + Arrays.toString(nodes)));
                return nodes;
            }
            catch (Exception e) {
                log.warn((Object)("Could not query cluster nodes " + e));
                return null;
            }
        }
    }
}

