/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.gateway.services;

import ome.services.blitz.gateway.services.DataService;
import ome.services.blitz.gateway.services.GatewayService;
import ome.services.blitz.gateway.services.ImageService;
import ome.services.blitz.gateway.services.RawFileStoreService;
import ome.services.blitz.gateway.services.RawPixelsStoreService;
import ome.services.blitz.gateway.services.RenderingService;
import ome.services.blitz.gateway.services.ThumbnailService;
import ome.services.blitz.gateway.services.impl.DataServiceImpl;
import ome.services.blitz.gateway.services.impl.ImageServiceImpl;
import ome.services.blitz.gateway.services.impl.RawFileStoreServiceImpl;
import ome.services.blitz.gateway.services.impl.RawPixelsStoreServiceImpl;
import ome.services.blitz.gateway.services.impl.RenderingServiceImpl;
import ome.services.blitz.gateway.services.impl.ThumbnailServiceImpl;
import omero.ServerError;
import omero.api.IContainerPrx;
import omero.api.IPixelsPrx;
import omero.api.IProjectionPrx;
import omero.api.IQueryPrx;
import omero.api.IScriptPrx;
import omero.api.ITypesPrx;
import omero.api.IUpdatePrx;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ThumbnailStorePrx;

public class GatewayFactory
implements GatewayService {
    private ServiceFactoryPrx serviceFactory;
    private IQueryPrx iQuery;
    private IContainerPrx iContainer;
    private IScriptPrx iScript;
    private ITypesPrx iTypes;
    private IPixelsPrx iPixels;
    private IUpdatePrx iUpdate;
    private IProjectionPrx iProjection;
    private RenderingService renderingService;
    private ThumbnailService thumbnailService;
    private RawPixelsStoreService rawPixelsService;
    private RawFileStoreService rawFileService;
    private RawPixelsStorePrx rawPixelsStore;
    private RawFileStorePrx rawFileStore;
    private ThumbnailStorePrx thumbnailStore;
    private RenderingEnginePrx renderingEngine;
    private ImageService imageService;
    private DataService dataService;

    public GatewayFactory(ServiceFactoryPrx serviceFactory) throws ServerError {
        this.serviceFactory = serviceFactory;
        this.createServices();
    }

    private void createServices() throws ServerError {
        this.iQuery = this.serviceFactory.getQueryService();
        this.iPixels = this.serviceFactory.getPixelsService();
        this.iUpdate = this.serviceFactory.getUpdateService();
        this.iScript = this.serviceFactory.getScriptService();
        this.iContainer = this.serviceFactory.getContainerService();
        this.iProjection = this.serviceFactory.getProjectionService();
        this.rawPixelsStore = this.serviceFactory.createRawPixelsStore();
        this.rawFileStore = this.serviceFactory.createRawFileStore();
        this.renderingEngine = this.serviceFactory.createRenderingEngine();
        this.thumbnailStore = this.serviceFactory.createThumbnailStore();
        this.iTypes = this.serviceFactory.getTypesService();
        this.rawFileService = new RawFileStoreServiceImpl(this.rawFileStore);
        this.rawPixelsService = new RawPixelsStoreServiceImpl(this.rawPixelsStore);
        this.renderingService = new RenderingServiceImpl(this.renderingEngine);
        this.thumbnailService = new ThumbnailServiceImpl(this.thumbnailStore);
        this.dataService = new DataServiceImpl(this);
        this.imageService = new ImageServiceImpl(this);
    }

    public ImageService getImageService() {
        return this.imageService;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public RawFileStoreService getRawFileStoreService() {
        return this.rawFileService;
    }

    public RawPixelsStoreService getRawPixelsStoreService() {
        return this.rawPixelsService;
    }

    public ThumbnailService getThumbnailStoreService() {
        return this.thumbnailService;
    }

    public RenderingService getRenderingService() {
        return this.renderingService;
    }

    public void closeService() throws ServerError {
        this.serviceFactory.closeOnDestroy();
        this.serviceFactory = null;
    }

    public void keepAlive() throws ServerError {
    }

    public IScriptPrx getIScript() {
        return this.iScript;
    }

    public IContainerPrx getIContainer() {
        return this.iContainer;
    }

    public ITypesPrx getITypes() {
        return this.iTypes;
    }

    public IQueryPrx getIQuery() {
        return this.iQuery;
    }

    public IPixelsPrx getIPixels() {
        return this.iPixels;
    }

    public IUpdatePrx getIUpdate() {
        return this.iUpdate;
    }
}

