/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import Ice.TieBase;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.model.internal.Permissions;
import ome.parameters.Parameters;
import ome.services.blitz.util.ApiCheck;
import ome.services.blitz.util.ApiConsistencyException;
import ome.services.blitz.util.BlitzOnly;
import ome.system.EventContext;
import ome.system.Roles;
import omeis.providers.re.RGBBuffer;
import omero.RInt;
import omero.RList;
import omero.RLong;
import omero.RObject;
import omero.RString;
import omero.RTime;
import omero.RType;
import omero.ServerError;
import omero.api._ServiceInterfaceOperations;
import omero.model.Details;
import omero.model.IObject;
import omero.romio.CodomainMapContext;
import omero.romio.PlaneDef;
import omero.sys.Filter;
import omero.sys.Principal;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiConsistencyCheck
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object arg0, String arg1) throws BeansException {
        TieBase tie;
        if (arg0 instanceof BlitzOnly) {
            return arg0;
        }
        if (arg0 instanceof TieBase && (tie = (TieBase)arg0).ice_delegate() instanceof BlitzOnly) {
            return arg0;
        }
        if (arg0 instanceof _ServiceInterfaceOperations) {
            Class<?> api;
            _ServiceInterfaceOperations sio = (_ServiceInterfaceOperations)arg0;
            Class ops = this.si(sio.getClass());
            String opsName = ops.getName();
            String apiName = opsName.replaceAll("omero", "ome").replaceFirst("_", "").replace("Operations", "");
            try {
                api = Class.forName(apiName);
            }
            catch (ClassNotFoundException e) {
                throw new FatalBeanException("No known API interface: " + apiName);
            }
            ArrayList<String> differences = new ArrayList<String>();
            Method[] opsMethods = ops.getDeclaredMethods();
            Method[] apiMethods = api.getDeclaredMethods();
            Map<String, Method> opsMap = this.map(opsMethods);
            Map<String, Method> apiMap = this.map(apiMethods);
            this.compareMethodNames(opsMap, apiMap, differences);
            for (String name : apiMap.keySet()) {
                Class amdReturn;
                Class<?> apiReturn;
                Class<?>[] apiParams;
                Method apiMethod = apiMap.get(name);
                Method opsMethod = opsMap.get(name);
                if (opsMethod == null) {
                    differences.add("Missing method: " + name);
                    continue;
                }
                Class<?>[] opsParams = opsMethod.getParameterTypes();
                if (opsParams.length - 2 != (apiParams = apiMethod.getParameterTypes()).length) {
                    differences.add(String.format("Native Java method has %d parameters while Blitz method has %d", apiParams.length, opsParams.length));
                    continue;
                }
                for (int i = 0; i < apiParams.length; ++i) {
                    Class<?> apiType = apiParams[i];
                    Class<?> opsType = opsParams[i + 1];
                    if (ApiConsistencyCheck.matches(apiType, opsType)) continue;
                    differences.add(String.format("Parameter type mismatch in %s: %s <> %s", apiMethod, apiType, opsType));
                }
                Class<?> opsReturn = opsMethod.getReturnType();
                if (!Void.TYPE.equals(opsReturn)) {
                    differences.add("Async calls must return void: " + opsMethod);
                }
                if (ApiConsistencyCheck.matches(apiReturn = apiMethod.getReturnType(), amdReturn = this.amdResponse(opsMethod))) continue;
                differences.add(String.format("Return type mismatch in %s: %s <> %s", apiMethod, apiReturn, opsReturn));
            }
            if (differences.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String difference : differences) {
                    sb.append(difference);
                    sb.append("\n");
                }
                throw new ApiConsistencyException(sb.toString(), apiMap, opsMap);
            }
        }
        return arg0;
    }

    private void compareMethodNames(Map<String, Method> opsMap, Map<String, Method> apiMap, List<String> differences) {
        for (String name : opsMap.keySet()) {
            Method opsMethod;
            List<Class<?>> excs;
            if (!apiMap.containsKey(name)) {
                differences.add("Extra method: " + name);
            }
            if ((excs = Arrays.asList((opsMethod = opsMap.get(name)).getExceptionTypes())).contains(ServerError.class)) continue;
            differences.add("Missing ServerError: " + name);
        }
    }

    public Object postProcessBeforeInitialization(Object arg0, String arg1) throws BeansException {
        return arg0;
    }

    public static boolean matches(Class apiType, Class opsType) {
        if (apiType == opsType || apiType.equals(opsType)) {
            return true;
        }
        ApiCheck check = new ApiCheck(apiType, opsType);
        if (check.matches(Integer.class, Integer.TYPE) || check.matches(Long.class, Long.TYPE) || check.matches(Double.class, Double.TYPE) || check.matches(Float.class, Float.TYPE)) {
            return false;
        }
        if (apiType.isArray() && (opsType.isArray() || Collection.class.isAssignableFrom(opsType))) {
            return true;
        }
        if (check.matches(Collection.class, List.class) || check.matches(omeis.providers.re.codomain.CodomainMapContext.class, CodomainMapContext.class) || check.matches(Date.class, RTime.class) || check.matches(ome.model.internal.Details.class, Details.class) || check.matches(Class.class, String.class) || check.matches(EventContext.class, omero.sys.EventContext.class) || check.matches(ome.parameters.Filter.class, Filter.class) || check.matches(Integer.class, RInt.class) || check.matches(ome.model.IObject.class, IObject.class) || check.matches(ome.model.IObject.class, RObject.class) || check.matches(List.class, RList.class) || check.matches(Long.class, RLong.class) || check.matches(Parameters.class, omero.sys.Parameters.class) || check.matches(omeis.providers.re.data.PlaneDef.class, PlaneDef.class) || check.matches(Permissions.class, omero.model.Permissions.class) || check.matches(ome.system.Principal.class, Principal.class) || check.matches(RGBBuffer.class, omero.romio.RGBBuffer.class) || check.matches(Roles.class, omero.sys.Roles.class) || check.matches(String.class, RString.class)) {
            return true;
        }
        return RType.class.isAssignableFrom(opsType) && (Object.class.equals((Object)apiType) || Timestamp.class.isAssignableFrom(apiType));
    }

    private Map<String, Method> map(Method[] methods) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method method : methods) {
            String name = method.getName();
            if (map.containsKey(name = name.replaceFirst("_async", ""))) {
                throw new RuntimeException("Method " + name + " contained multiple times in API.");
            }
            map.put(name, method);
        }
        return map;
    }

    private Class si(Class k) {
        if (!_ServiceInterfaceOperations.class.isAssignableFrom(k)) {
            return null;
        }
        Class sc = k.getSuperclass();
        if (sc != null && (sc = this.si(sc)) != null) {
            return sc;
        }
        for (Class<?> iface : k.getInterfaces()) {
            if (iface.equals(_ServiceInterfaceOperations.class)) {
                return k;
            }
            Class rv = this.si(iface);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    Class amdResponse(Method m) {
        Class<?> amd = m.getParameterTypes()[0];
        Method[] methods = amd.getMethods();
        Method response = null;
        for (Method method : methods) {
            if (!method.getName().equals("ice_response")) continue;
            if (response != null) {
                throw new RuntimeException("2 ice_response() methods found: " + m);
            }
            response = method;
        }
        if (response == null) {
            throw new RuntimeException("No ice_response() method found: " + m);
        }
        Class<?>[] responseTypes = response.getParameterTypes();
        if (responseTypes.length > 1) {
            throw new RuntimeException("More than one response type for " + m);
        }
        if (responseTypes.length == 1) {
            return responseTypes[0];
        }
        return Void.TYPE;
    }
}

