/*
 * Decompiled with CFR 0.152.
 */
package omero;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import Glacier2.RouterPrxHelper;
import Glacier2.SessionNotExistException;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.ConnectTimeoutException;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.Current;
import Ice.Identity;
import Ice.ImplicitContext;
import Ice.InitializationData;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import Ice.Util;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import omero.ClientError;
import omero.RType;
import omero.ServerError;
import omero.WrappedCreateSessionException;
import omero.api.ClientCallbackPrxHelper;
import omero.api.IAdminPrx;
import omero.api.ISessionPrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceFactoryPrxHelper;
import omero.api._ClientCallbackDisp;
import omero.model.DetailsI;
import omero.model.OriginalFile;
import omero.model.PermissionsI;
import omero.rtypes;
import omero.util.ObjectFactoryRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class client {
    private static final Set<client> CLIENTS = Collections.synchronizedSet(new HashSet());
    private String __uuid;
    private InitializationData __previous;
    private ObjectAdapter __oa;
    private Communicator __ic;
    private ServiceFactoryPrx __sf;
    private final Object lock = new Object();

    private static Properties defaultRouter(String host, int port) {
        Properties p = new Properties();
        p.setProperty("omero.host", host);
        p.setProperty("omero.port", Integer.toString(port));
        return p;
    }

    public client() {
        this(new InitializationData());
    }

    public client(InitializationData id) {
        this.init(id);
    }

    public client(String host) {
        this(client.defaultRouter(host, 4063));
    }

    public client(String host, int port) {
        this(client.defaultRouter(host, port));
    }

    public client(String[] args) {
        this(args, new InitializationData());
    }

    public client(String[] args, InitializationData id) {
        if (id.properties == null) {
            id.properties = Util.createProperties((String[])args);
        }
        args = id.properties.parseIceCommandLineOptions(args);
        args = id.properties.parseCommandLineOptions("omero", args);
        this.init(id);
    }

    public client(File ... files) {
        InitializationData id = new InitializationData();
        id.properties = Util.createProperties((String[])new String[0]);
        for (File file : files) {
            id.properties.load(file.getAbsolutePath());
        }
        this.init(id);
    }

    public client(Map p) {
        InitializationData id = new InitializationData();
        id.properties = Util.createProperties((String[])new String[0]);
        if (p != null) {
            for (Object key : p.keySet()) {
                id.properties.setProperty(key.toString(), p.get(key).toString());
            }
        }
        this.init(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InitializationData id) {
        if (id == null) {
            throw new ClientError("No initialization data provided.");
        }
        if (id.properties == null) {
            id.properties = Util.createProperties((String[])new String[0]);
        }
        id.properties.setProperty("Ice.ImplicitContext", "Shared");
        String messageSize = id.properties.getProperty("Ice.MessageSizeMax");
        if (messageSize == null || messageSize.length() == 0) {
            id.properties.setProperty("Ice.MessageSizeMax", Integer.toString(65536));
        }
        this.parseAndSetInt(id, "Ice.Override.ConnectTimeout", 5000);
        String endpoints = id.properties.getProperty("omero.ClientCallback.Endpoints");
        if (endpoints == null || endpoints.length() == 0) {
            id.properties.setProperty("omero.ClientCallback.Endpoints", "tcp");
        }
        String port = this.parseAndSetInt(id, "omero.port", 4063);
        String router = id.properties.getProperty("Ice.Default.Router");
        if (router == null || router.length() == 0) {
            router = "OMERO.Glacier2/router:tcp -p @omero.port@ -h @omero.host@";
        }
        String host = id.properties.getPropertyWithDefault("omero.host", "<\"omero.host\" not set>");
        router = router.replaceAll("@omero.port@", port);
        router = router.replaceAll("@omero.host@", host);
        id.properties.setProperty("Ice.Default.Router", router);
        String dump = id.properties.getProperty("omero.dump");
        if (dump != null && dump.length() > 0) {
            for (String prefix : Arrays.asList("omero", "Ice")) {
                Map prefixed = id.properties.getPropertiesForPrefix(prefix);
                for (String key : prefixed.keySet()) {
                    System.out.println(String.format("%s=%s", key, prefixed.get(key)));
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.__ic != null) {
                throw new ClientError("Client already initialized.");
            }
            this.__ic = Util.initialize((InitializationData)id);
            if (this.__ic == null) {
                throw new ClientError("Improper initialization");
            }
            ObjectFactoryRegistrar.registerObjectFactory(this.__ic, ObjectFactoryRegistrar.INSTANCE);
            for (rtypes.ObjectFactory of : rtypes.ObjectFactories.values()) {
                of.register(this.__ic);
            }
            this.__ic.addObjectFactory(DetailsI.Factory, DetailsI.ice_staticId());
            this.__ic.addObjectFactory(PermissionsI.Factory, PermissionsI.ice_staticId());
            this.__uuid = UUID.randomUUID().toString();
            ImplicitContext ctx = this.__ic.getImplicitContext();
            if (ctx == null) {
                throw new ClientError("Ice.ImplicitContext not set to Shared");
            }
            ctx.put("omero.client.uuid", this.__uuid);
            this.__oa = this.__ic.createObjectAdapter("omero.ClientCallback");
            CallbackI cb = new CallbackI(this.__ic, this.__oa);
            this.__oa.add((Ice.Object)cb, Util.stringToIdentity((String)("ClientCallback/" + this.__uuid)));
            this.__oa.activate();
            CLIENTS.add(this);
        }
    }

    protected void __del__() {
        try {
            this.closeSession();
        }
        catch (Exception e) {
            System.out.println("Ignoring error in client.__del__()");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Communicator getCommunicator() {
        Object object = this.lock;
        synchronized (object) {
            if (this.__ic == null) {
                throw new ClientError("No Ice.Communicator active; call createSession() or create a new client instance.");
            }
            return this.__ic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFactoryPrx getSession() {
        Object object = this.lock;
        synchronized (object) {
            if (this.__sf == null) {
                throw new ClientError("Call createSession() to login.");
            }
            return this.__sf;
        }
    }

    @Deprecated
    public ServiceFactoryPrx getServiceFactory() {
        return this.getSession();
    }

    public ImplicitContext getImplicitContext() {
        return this.getCommunicator().getImplicitContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ice.Properties getProperties() {
        Object object = this.lock;
        synchronized (object) {
            return this.__ic.getProperties();
        }
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public ServiceFactoryPrx joinSession(String session) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        return this.createSession(session, session);
    }

    public ServiceFactoryPrx createSession() throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        return this.createSession(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFactoryPrx createSession(String username, String password) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        Object object = this.lock;
        synchronized (object) {
            if (this.__sf != null) {
                throw new ClientError("Session already active. Create a new omero.client or closeSession()");
            }
            if (this.__ic == null) {
                if (this.__previous == null) {
                    throw new ClientError("No previous data to recreate communicator.");
                }
                this.init(this.__previous);
                this.__previous = null;
            }
            if (username == null && ((username = this.getProperty("omero.user")) == null || "".equals(username))) {
                throw new ClientError("No username specified");
            }
            if (password == null && (password = this.getProperty("omero.pass")) == null) {
                throw new ClientError("No password specified");
            }
            SessionPrx prx = null;
            int retries = 0;
            while (retries < 3) {
                String reason = null;
                if (retries > 0) {
                    this.__ic.getLogger().warning(reason + " - createSession retry: " + retries);
                }
                try {
                    prx = client.getRouter(this.__ic).createSession(username, password);
                    break;
                }
                catch (WrappedCreateSessionException wrapped) {
                    if (!wrapped.concurrency) {
                        throw wrapped;
                    }
                    reason = wrapped.type + ":" + wrapped.reason;
                    ++retries;
                }
                catch (ConnectTimeoutException cte) {
                    reason = "Ice.ConnectTimeoutException:" + cte.getMessage();
                    ++retries;
                }
            }
            if (null == prx) {
                throw new ClientError("Obtained null object proxy");
            }
            this.__sf = ServiceFactoryPrxHelper.uncheckedCast(prx);
            if (this.__sf == null) {
                throw new ClientError("Obtained object proxy is not a ServiceFactory");
            }
            Identity id = this.__ic.stringToIdentity("ClientCallback/" + this.__uuid);
            ObjectPrx raw = this.__oa.createProxy(id);
            this.__sf.setCallback(ClientCallbackPrxHelper.uncheckedCast(raw));
            return this.__sf;
        }
    }

    public static Glacier2.RouterPrx getRouter(Communicator comm) {
        RouterPrx prx = comm.getDefaultRouter();
        if (prx == null) {
            throw new ClientError("No default router found.");
        }
        Glacier2.RouterPrx router = RouterPrxHelper.checkedCast((ObjectPrx)prx);
        if (router == null) {
            throw new ClientError("Error obtaining Glacier2 router");
        }
        router = RouterPrxHelper.uncheckedCast((ObjectPrx)router.ice_context(comm.getImplicitContext().getContext()));
        return router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() {
        Object object = this.lock;
        synchronized (object) {
            ServiceFactoryPrx oldSf = this.__sf;
            this.__sf = null;
            ObjectAdapter oldOa = this.__oa;
            this.__oa = null;
            Communicator oldIc = this.__ic;
            this.__ic = null;
            if (oldIc == null) {
                return;
            }
            if (oldOa != null) {
                try {
                    oldOa.deactivate();
                }
                catch (Exception e) {
                    oldIc.getLogger().warning("While deactivating adapter: " + e.getMessage());
                }
            }
            this.__previous = new InitializationData();
            this.__previous.properties = oldIc.getProperties()._clone();
            try {
                client.getRouter(oldIc).destroySession();
            }
            catch (SessionNotExistException snee) {
            }
            catch (ConnectionLostException cle) {
            }
            catch (ConnectionRefusedException cle) {
            }
            catch (ConnectTimeoutException cte) {
            }
            finally {
                oldIc.destroy();
            }
        }
    }

    public String sha1(File file) {
        throw new RuntimeException("NYI");
    }

    public void upload(File file, OriginalFile fileObject, Integer blockSize) {
    }

    public RType getInput(String key) throws ServerError {
        return this.env().getInput(this.sess(), key);
    }

    public RType getOutput(String key) throws ServerError {
        return this.env().getOutput(this.sess(), key);
    }

    public void setInput(String key, RType value) throws ServerError {
        this.env().setInput(this.sess(), key, value);
    }

    public void setOutput(String key, RType value) throws ServerError {
        this.env().setOutput(this.sess(), key, value);
    }

    public List<String> getInputKeys() throws ServerError {
        return this.env().getInputKeys(this.sess());
    }

    public List<String> getOutputKeys() throws ServerError {
        return this.env().getOutputKeys(this.sess());
    }

    protected String parseAndSetInt(InitializationData data, String key, int newValue) {
        String currentValue = data.properties.getProperty(key);
        if (currentValue == null || currentValue.length() == 0) {
            String newStr = Integer.toString(newValue);
            data.properties.setProperty(key, newStr);
            currentValue = newStr;
        }
        return currentValue;
    }

    protected static String filesToString(File ... files) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < files.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(files[i].getAbsolutePath());
        }
        return sb.toString();
    }

    protected ISessionPrx env() throws ServerError {
        ISessionPrx s = this.getSession().getSessionService();
        return s;
    }

    protected String sess() throws ServerError {
        IAdminPrx a = this.getSession().getAdminService();
        String u = a.getEventContext().sessionUuid;
        return u;
    }

    private CallbackI _getCb() {
        Ice.Object obj = this.__oa.find(Util.stringToIdentity((String)("ClientCallback/" + this.__uuid)));
        if (!(obj instanceof CallbackI)) {
            throw new ClientError("Cannot find CallbackI in ObjectAdapter");
        }
        return (CallbackI)obj;
    }

    public void onHearbeat(Runnable runnable) {
        this._getCb().onHeartbeat = runnable;
    }

    public void onSessionClosed(Runnable runnable) {
        this._getCb().onSessionClosed = runnable;
    }

    public void onShutdown(Runnable runnable) {
        this._getCb().onShutdown = runnable;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                HashSet clients = new HashSet(CLIENTS);
                for (client client2 : clients) {
                    try {
                        client2.__del__();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static class CallbackI
    extends _ClientCallbackDisp {
        private final Communicator ic;
        private final ObjectAdapter oa;
        private Runnable _noop = new Runnable(){

            public void run() {
            }
        };
        private Runnable _closeSession = new Runnable(){

            public void run() {
                try {
                    CallbackI.this.oa.deactivate();
                }
                catch (Exception e) {
                    System.err.println("On session closed: " + e.getMessage());
                }
            }
        };
        private Runnable onHeartbeat = this._noop;
        private Runnable onSessionClosed = this._noop;
        private Runnable onShutdown = this._noop;

        public CallbackI(Communicator ic, ObjectAdapter oa) {
            this.ic = ic;
            this.oa = oa;
        }

        public void requestHeartbeat(Current __current) {
            this.execute(this.onHeartbeat, "heartbeat");
        }

        public void shutdownIn(long milliseconds, Current __current) {
            this.execute(this.onShutdown, "shutdown");
        }

        public void sessionClosed(Current __current) {
            this.execute(this.onSessionClosed, "sessionClosed");
        }

        protected void execute(Runnable runnable, String action) {
            try {
                runnable.run();
                this.ic.getLogger().trace("ClientCallback", action + " run");
            }
            catch (Exception e) {
                try {
                    this.ic.getLogger().error("Error performing " + action + ": " + e.getMessage());
                }
                catch (Exception e2) {
                    System.err.println("Error performing " + action + " :" + e.getMessage());
                    System.err.println("(Stderr due to: " + e2.getMessage() + ")");
                }
            }
        }
    }
}

