/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Pixels;
import omero.model.PlaneInfo;
import omero.model.PlaneInfoAnnotationLink;
import omero.model.PlaneInfoAnnotationLinkI;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaneInfoI
extends PlaneInfo
implements ModelBased {
    public static final String PIXELS = "ome.model.core.PlaneInfo_pixels";
    public static final String THEZ = "ome.model.core.PlaneInfo_theZ";
    public static final String THEC = "ome.model.core.PlaneInfo_theC";
    public static final String THET = "ome.model.core.PlaneInfo_theT";
    public static final String DELTAT = "ome.model.core.PlaneInfo_deltaT";
    public static final String POSITIONX = "ome.model.core.PlaneInfo_positionX";
    public static final String POSITIONY = "ome.model.core.PlaneInfo_positionY";
    public static final String POSITIONZ = "ome.model.core.PlaneInfo_positionZ";
    public static final String EXPOSURETIME = "ome.model.core.PlaneInfo_exposureTime";
    public static final String ANNOTATIONLINKS = "ome.model.core.PlaneInfo_annotationLinks";
    public static final String DETAILS = "ome.model.core.PlaneInfo_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public PlaneInfoI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public PlaneInfoI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public PlaneInfoI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadPixels();
        this.unloadTheZ();
        this.unloadTheC();
        this.unloadTheT();
        this.unloadDeltaT();
        this.unloadPositionX();
        this.unloadPositionY();
        this.unloadPositionZ();
        this.unloadExposureTime();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        PlaneInfoI copy = new PlaneInfoI();
        copy.id = this.id;
        copy.version = this.version;
        copy.pixels = this.pixels == null ? null : (Pixels)this.pixels.proxy();
        copy.theZ = this.theZ;
        copy.theC = this.theC;
        copy.theT = this.theT;
        copy.deltaT = this.deltaT;
        copy.positionX = this.positionX;
        copy.positionY = this.positionY;
        copy.positionZ = this.positionZ;
        copy.exposureTime = this.exposureTime;
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<PlaneInfoAnnotationLink>();
            for (PlaneInfoAnnotationLink item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (PlaneInfoAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new PlaneInfoI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadPixels() {
        this.pixels = null;
    }

    @Override
    public Pixels getPixels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pixels;
    }

    @Override
    public void setPixels(Pixels pixels, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pixels = pixels;
    }

    private void copyPixels(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.pixels = (Pixels)mapper.findTarget(source.getPixels());
    }

    private void fillPixels(ome.model.core.PlaneInfo target, IceMapper mapper) {
        target.putAt(PIXELS, (Object)mapper.reverse((ModelBased)this.getPixels()));
    }

    public void unloadTheZ() {
        this.theZ = null;
    }

    @Override
    public RInt getTheZ(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.theZ;
    }

    @Override
    public void setTheZ(RInt theZ, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.theZ = theZ;
    }

    private void copyTheZ(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.theZ = source.getTheZ() == null ? null : rtypes.rint(source.getTheZ());
    }

    private void fillTheZ(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setTheZ((Integer)mapper.fromRType(this.getTheZ()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadTheC() {
        this.theC = null;
    }

    @Override
    public RInt getTheC(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.theC;
    }

    @Override
    public void setTheC(RInt theC, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.theC = theC;
    }

    private void copyTheC(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.theC = source.getTheC() == null ? null : rtypes.rint(source.getTheC());
    }

    private void fillTheC(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setTheC((Integer)mapper.fromRType(this.getTheC()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadTheT() {
        this.theT = null;
    }

    @Override
    public RInt getTheT(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.theT;
    }

    @Override
    public void setTheT(RInt theT, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.theT = theT;
    }

    private void copyTheT(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.theT = source.getTheT() == null ? null : rtypes.rint(source.getTheT());
    }

    private void fillTheT(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setTheT((Integer)mapper.fromRType(this.getTheT()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDeltaT() {
        this.deltaT = null;
    }

    @Override
    public RDouble getDeltaT(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.deltaT;
    }

    @Override
    public void setDeltaT(RDouble deltaT, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.deltaT = deltaT;
    }

    private void copyDeltaT(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.deltaT = source.getDeltaT() == null ? null : rtypes.rdouble(source.getDeltaT());
    }

    private void fillDeltaT(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setDeltaT((Double)mapper.fromRType(this.getDeltaT()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPositionX() {
        this.positionX = null;
    }

    @Override
    public RDouble getPositionX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.positionX;
    }

    @Override
    public void setPositionX(RDouble positionX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.positionX = positionX;
    }

    private void copyPositionX(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.positionX = source.getPositionX() == null ? null : rtypes.rdouble(source.getPositionX());
    }

    private void fillPositionX(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setPositionX((Double)mapper.fromRType(this.getPositionX()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPositionY() {
        this.positionY = null;
    }

    @Override
    public RDouble getPositionY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.positionY;
    }

    @Override
    public void setPositionY(RDouble positionY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.positionY = positionY;
    }

    private void copyPositionY(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.positionY = source.getPositionY() == null ? null : rtypes.rdouble(source.getPositionY());
    }

    private void fillPositionY(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setPositionY((Double)mapper.fromRType(this.getPositionY()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPositionZ() {
        this.positionZ = null;
    }

    @Override
    public RDouble getPositionZ(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.positionZ;
    }

    @Override
    public void setPositionZ(RDouble positionZ, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.positionZ = positionZ;
    }

    private void copyPositionZ(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.positionZ = source.getPositionZ() == null ? null : rtypes.rdouble(source.getPositionZ());
    }

    private void fillPositionZ(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setPositionZ((Double)mapper.fromRType(this.getPositionZ()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadExposureTime() {
        this.exposureTime = null;
    }

    @Override
    public RDouble getExposureTime(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.exposureTime;
    }

    @Override
    public void setExposureTime(RDouble exposureTime, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.exposureTime = exposureTime;
    }

    private void copyExposureTime(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.exposureTime = source.getExposureTime() == null ? null : rtypes.rdouble(source.getExposureTime());
    }

    private void fillExposureTime(ome.model.core.PlaneInfo target, IceMapper mapper) {
        try {
            target.setExposureTime((Double)mapper.fromRType(this.getExposureTime()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.core.PlaneInfo source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.core.PlaneInfo target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addPlaneInfoAnnotationLink(PlaneInfoAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllPlaneInfoAnnotationLinkSet(List<PlaneInfoAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (PlaneInfoAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removePlaneInfoAnnotationLink(PlaneInfoAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    public void removePlaneInfoAnnotationLinkSet(Collection<PlaneInfoAnnotationLink> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (PlaneInfoAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (PlaneInfoAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(PlaneInfo toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<PlaneInfoAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (PlaneInfoAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<PlaneInfoAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public PlaneInfoAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        PlaneInfoAnnotationLinkI link = new PlaneInfoAnnotationLinkI();
        link.link(this, addition);
        this.addPlaneInfoAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addPlaneInfoAnnotationLinkToBoth(PlaneInfoAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<PlaneInfoAnnotationLink> findPlaneInfoAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<PlaneInfoAnnotationLink> result = new ArrayList<PlaneInfoAnnotationLink>();
        for (PlaneInfoAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<PlaneInfoAnnotationLink> toRemove = this.findPlaneInfoAnnotationLink(removal);
        Iterator<PlaneInfoAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePlaneInfoAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removePlaneInfoAnnotationLinkFromBoth(PlaneInfoAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (PlaneInfoAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.core.PlaneInfo) {
            ome.model.core.PlaneInfo source = (ome.model.core.PlaneInfo)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyPixels(source, mapper);
                this.copyTheZ(source, mapper);
                this.copyTheC(source, mapper);
                this.copyTheT(source, mapper);
                this.copyDeltaT(source, mapper);
                this.copyPositionX(source, mapper);
                this.copyPositionY(source, mapper);
                this.copyPositionZ(source, mapper);
                this.copyExposureTime(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("PlaneInfo cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.core.PlaneInfo target = new ome.model.core.PlaneInfo();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillPixels(target, mapper);
            this.fillTheZ(target, mapper);
            this.fillTheC(target, mapper);
            this.fillTheT(target, mapper);
            this.fillDeltaT(target, mapper);
            this.fillPositionX(target, mapper);
            this.fillPositionY(target, mapper);
            this.fillPositionZ(target, mapper);
            this.fillExposureTime(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<PlaneInfoI> cast(List list) {
        return list;
    }
}

