/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import java.io.File;
import java.util.List;
import ome.conditions.ApiUsageException;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import omero.model.Pixels;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEROImportFixture {
    Log log = LogFactory.getLog(OMEROImportFixture.class);
    protected OMEROMetadataStoreClient store;
    private OMEROWrapper reader;
    private ImportLibrary library;
    private File file;
    private List<Pixels> pixels;
    private String name;

    public OMEROImportFixture(OMEROMetadataStoreClient store) {
        this(store, new OMEROWrapper());
    }

    public OMEROImportFixture(OMEROMetadataStoreClient store, OMEROWrapper reader) {
        this.store = store;
        this.reader = reader;
    }

    public void setUp() throws Exception {
        this.library = new ImportLibrary(this.store, this.reader);
    }

    public void tearDown() {
        this.store = null;
        this.library = null;
        try {
            try {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.reader = null;
        }
    }

    public List<Pixels> fullImport(File f, String name) throws Exception {
        this.setUp();
        try {
            this.setFile(f);
            this.setName(name);
            this.doImport();
            List<Pixels> list = this.getPixels();
            return list;
        }
        finally {
            this.tearDown();
        }
    }

    public void doImport(ImportLibrary.Step step) throws Exception {
        if (step == null) {
            throw new ApiUsageException("Step may not be null.");
        }
        String fileName = this.file.getAbsolutePath();
        this.library.setTarget(null);
        this.pixels = this.library.importImage(this.file, 0, 0, 1, fileName, null, false, null);
    }

    public void doImport() throws Exception {
        this.doImport(new ImportLibrary.Step(){

            public void step(int series, int n) {
            }
        });
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Pixels> getPixels() {
        return this.pixels;
    }
}

