/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.enums.handler;

import java.util.HashMap;
import ome.formats.enums.EnumerationException;
import ome.formats.enums.handler.EnumerationHandler;
import ome.formats.enums.handler.PatternSet;
import omero.model.Correction;
import omero.model.IObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrectionEnumHandler
implements EnumerationHandler {
    static final Class<? extends IObject> HANDLER_FOR = Correction.class;
    private static final PatternSet[] searchPatterns = new PatternSet[]{new PatternSet("^\\s*Pl.*Apo.*$", "PlanApo")};

    CorrectionEnumHandler() {
    }

    @Override
    public IObject findEnumeration(HashMap<String, IObject> enumerations, String value) {
        PatternSet[] patternSetArray = searchPatterns;
        int n = searchPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            PatternSet x = patternSetArray[n2];
            if (x.pattern.matcher(value).matches()) {
                IObject enumeration = enumerations.get(x.value);
                if (enumeration == null) {
                    throw new EnumerationException(String.format("Matched value %s with regex %s. Could not find resulting value in enumerations.", x.pattern.pattern(), x.value), HANDLER_FOR, value);
                }
                return enumeration;
            }
            ++n2;
        }
        return null;
    }
}

