/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.HistoryDB;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.JOutlookBar;
import ome.formats.importer.LoginHandler;
import ome.formats.importer.util.ETable;
import ome.formats.importer.util.GuiCommonElements;
import omero.model.Dataset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;

public class HistoryTable
extends JPanel
implements ActionListener,
PropertyChangeListener,
IObserver,
IObservable {
    private static Log log = LogFactory.getLog(HistoryTable.class);
    ArrayList<IObserver> observers = new ArrayList();
    private static final long serialVersionUID = 1L;
    public HistoryTableModel table = new HistoryTableModel();
    public ETable eTable = new ETable(this.table);
    private static final String DATE_FORMAT = "yy/MM/dd";
    GuiCommonElements gui;
    Boolean debug = false;
    int buttonSize = 40;
    int statusWidth = 100;
    int dateWidth = 180;
    String searchIcon = "gfx/add.png";
    String clearIcon = "gfx/nuvola_editdelete16.png";
    JPanel mainPanel;
    JPanel topSidePanel;
    JPanel bottomSidePanel;
    JPanel filterPanel;
    JTextPane sideLabel;
    JLabel fromLabel;
    JLabel toLabel;
    JXDatePicker fromDate;
    JXDatePicker toDate;
    JTextField searchField;
    JTextPane filterLabel;
    JCheckBox doneCheckBox;
    JCheckBox failedCheckBox;
    JCheckBox invalidCheckBox;
    JCheckBox pendingCheckBox;
    JButton searchBtn;
    JButton reimportBtn;
    JButton clearBtn;
    public static HistoryDB db = null;
    long experimenterID;
    private OMEROMetadataStoreClient store;
    JOutlookBar outlookBar = new JOutlookBar();
    JList todayList;
    JList yesterdayList;
    JList thisWeekList;
    JList lastWeekList;
    JList thisMonthList;
    private boolean unknownProjectDatasetFlag;
    private static HistoryTable ref;

    HistoryTable() {
        this.todayList = new JList(this.outlookBar.today);
        this.yesterdayList = new JList(this.outlookBar.yesterday);
        this.thisWeekList = new JList(this.outlookBar.thisWeek);
        this.lastWeekList = new JList(this.outlookBar.lastWeek);
        this.thisMonthList = new JList(this.outlookBar.thisMonth);
        try {
            this.outlookBar.addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            log.error((Object)"Exception adding property change listener.", (Throwable)ex);
        }
        db = HistoryDB.getHistoryDB();
        db.addObserver(this);
        this.gui = new GuiCommonElements();
        this.setLayout(new BoxLayout(this, 2));
        this.setOpaque(false);
        double[][] mainTable = new double[][]{{170.0, 10.0, -1.0, 80.0}, {5.0, 30.0, 35.0, 40.0, -1.0, 35.0, 5.0}};
        this.mainPanel = this.gui.addMainPanel(this, mainTable, 0, 0, 0, 0, this.debug);
        double[][] topSideTable = new double[][]{{-1.0}, {20.0, 20.0, 20.0, 20.0}};
        this.topSidePanel = this.gui.addBorderedPanel(this.mainPanel, topSideTable, " Date Filter ", this.debug);
        String[] dateFormats = new String[]{DATE_FORMAT};
        this.fromDate = new JXDatePicker();
        this.fromDate.setToolTipText("Pick a from date.");
        this.fromDate.setFormats(dateFormats);
        this.toDate = new JXDatePicker();
        this.toDate.setToolTipText("Pick a to date.");
        this.toDate.setFormats(dateFormats);
        this.fromLabel = new JLabel("From (yy/mm/dd):");
        this.topSidePanel.add((Component)this.fromLabel, "0,0");
        this.topSidePanel.add((Component)this.fromDate, "0,1");
        this.toLabel = new JLabel("To (yy/mm/dd):");
        this.topSidePanel.add((Component)this.toLabel, "0,2");
        this.topSidePanel.add((Component)this.toDate, "0,3");
        double[][] bottomSideTable = new double[][]{{-1.0}, {-1.0}};
        this.outlookBar.addBar("Today", this.outlookBar.getListPanel(this.todayList));
        this.outlookBar.addBar("Yesterday", this.outlookBar.getListPanel(this.yesterdayList));
        this.outlookBar.addBar("This Week", this.outlookBar.getListPanel(this.thisWeekList));
        this.outlookBar.addBar("Last Week", this.outlookBar.getListPanel(this.lastWeekList));
        this.outlookBar.addBar("This Month", this.outlookBar.getListPanel(this.thisMonthList));
        this.outlookBar.setVisibleBar(0);
        this.bottomSidePanel = this.gui.addBorderedPanel(this.mainPanel, bottomSideTable, " Quick Date ", this.debug);
        this.bottomSidePanel.add((Component)this.outlookBar, "f,f");
        this.clearBtn = this.gui.addIconButton(this.mainPanel, "Wipe History", this.clearIcon, 130, 32, 83, "Click here to clear your history log.", "0,5,c,c", this.debug);
        this.clearBtn.setActionCommand("history_clear");
        this.clearBtn.addActionListener(this);
        this.searchField = this.gui.addTextField(this.mainPanel, "Name Filter: ", "*.*", 78, "Type in a file name to search for here.", "", -2.0, "2,1, 0, 0", this.debug);
        this.searchBtn = this.gui.addButton(this.mainPanel, "Search", 83, "Click here to search", "3,1,c,c", this.debug);
        this.searchBtn.setActionCommand("history_search");
        this.searchBtn.addActionListener(this);
        double[][] filterTable = new double[][]{{100.0, 70.0, 70.0, 70.0, 90.0, -1.0}, {30.0}};
        this.filterPanel = this.gui.addPlanePanel(this.mainPanel, filterTable, this.debug);
        this.filterLabel = this.gui.addTextPane(this.filterPanel, "Status Filters: ", "0,0,r,c", this.debug);
        this.doneCheckBox = this.gui.addCheckBox(this.filterPanel, "Done", "1,0,l,c", this.debug);
        this.failedCheckBox = this.gui.addCheckBox(this.filterPanel, "Failed", "2,0,l,c", this.debug);
        this.invalidCheckBox = this.gui.addCheckBox(this.filterPanel, "Invalid", "3,0,l,c", this.debug);
        this.pendingCheckBox = this.gui.addCheckBox(this.filterPanel, "Pending", "4,0,1,c", this.debug);
        this.doneCheckBox.setSelected(true);
        this.failedCheckBox.setSelected(true);
        this.invalidCheckBox.setSelected(true);
        this.pendingCheckBox.setSelected(true);
        this.doneCheckBox.addActionListener(this);
        this.failedCheckBox.addActionListener(this);
        this.invalidCheckBox.addActionListener(this);
        this.pendingCheckBox.addActionListener(this);
        TableColumnModel cModel = this.eTable.getColumnModel();
        TableColumn hiddenColumn = cModel.getColumn(6);
        cModel.removeColumn(hiddenColumn);
        hiddenColumn = cModel.getColumn(5);
        cModel.removeColumn(hiddenColumn);
        hiddenColumn = cModel.getColumn(4);
        cModel.removeColumn(hiddenColumn);
        MyTableHeaderRenderer myHeader = new MyTableHeaderRenderer();
        cModel.getColumn(0).setHeaderRenderer(myHeader);
        cModel.getColumn(1).setHeaderRenderer(myHeader);
        cModel.getColumn(2).setHeaderRenderer(myHeader);
        cModel.getColumn(3).setHeaderRenderer(myHeader);
        cModel.getColumn(0).setCellRenderer(new LeftDotRenderer());
        cModel.getColumn(1).setCellRenderer(new TextCellCenter());
        cModel.getColumn(2).setCellRenderer(new TextCellCenter());
        cModel.getColumn(3).setCellRenderer(new TextCellCenter());
        TableColumn statusColumn = this.eTable.getColumnModel().getColumn(3);
        statusColumn.setPreferredWidth(this.statusWidth);
        statusColumn.setMaxWidth(this.statusWidth);
        statusColumn.setMinWidth(this.statusWidth);
        TableColumn dateColumn = this.eTable.getColumnModel().getColumn(2);
        dateColumn.setPreferredWidth(this.dateWidth);
        dateColumn.setMaxWidth(this.dateWidth);
        dateColumn.setMinWidth(this.dateWidth);
        JScrollPane scrollPane = new JScrollPane(this.eTable);
        this.reimportBtn = this.gui.addButton(this.filterPanel, "Reimport", 82, "Click here to reimport these images", "5,0,r,c", this.debug);
        this.reimportBtn.setEnabled(false);
        this.reimportBtn.setActionCommand("history_reimport");
        this.reimportBtn.addActionListener(this);
        this.mainPanel.add((Component)scrollPane, "2,3,3,5");
        this.mainPanel.add((Component)this.bottomSidePanel, "0,4,0,0");
        this.mainPanel.add((Component)this.topSidePanel, "0,0,0,3");
        this.mainPanel.add((Component)this.filterPanel, "2,2,3,1");
        this.add(this.mainPanel);
    }

    public static HistoryTable getHistoryTable() {
        if (ref == null) {
            try {
                ref = new HistoryTable();
            }
            catch (Exception e) {
                log.error((Object)"Could not start history DB.", (Throwable)e);
                if (!HistoryDB.alertOnce) {
                    JOptionPane.showMessageDialog(null, "We were not able to connect to the history DB.\nMake sure you do not have a second importer\nrunning and try again.\n\nIn the meantime, you will still be able to use \nthe importer, but the history feature will be disable.", "Warning", 0);
                }
                ref = null;
                HistoryDB.alertOnce = true;
            }
        }
        return ref;
    }

    private void getExperimenterID() {
        try {
            LoginHandler loginHandler = LoginHandler.getLoginHandler();
            this.store = loginHandler.getMetadataStore();
            this.experimenterID = this.store.getExperimenterID();
        }
        catch (NullPointerException e) {
            this.experimenterID = -1L;
        }
    }

    private void ClearHistory() {
        String message = "This will delete your import history. \nAre you sure you want to continue?";
        Object[] o = new Object[]{"Yes", "No"};
        int result = JOptionPane.showOptionDialog(this, message, "Warning", -1, 2, null, o, o[1]);
        if (result == 0) {
            db.wipeUserHistory(this.experimenterID);
            this.updateOutlookBar();
            this.getFileQuery(-1, this.experimenterID, this.searchField.getText(), this.fromDate.getDate(), this.toDate.getDate());
        }
    }

    public void getImportQuery(long ExperimenterID) {
        try {
            ResultSet rs = db.getImportResults(db, "import_table", ExperimenterID);
            Vector<Object> row = new Vector<Object>();
            int count = this.table.getRowCount();
            int r = count - 1;
            while (r >= 0) {
                this.table.removeRow(r);
                --r;
            }
            while (rs.next()) {
                row.add(rs.getObject("date"));
                row.add(rs.getObject("status"));
                this.table.addRow(row);
            }
            rs.close();
            db.shutdown();
        }
        catch (SQLException ex3) {
            log.error((Object)"SQL exeception.", (Throwable)ex3);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void getFileQuery(int importID, long experimenterID, String string, Date from, Date to) {
        try {
            ResultSet rs = db.getFileResults(db, "file_table", importID, experimenterID, string, this.doneCheckBox.isSelected(), this.failedCheckBox.isSelected(), this.invalidCheckBox.isSelected(), this.pendingCheckBox.isSelected(), from, to);
            int count = this.table.getRowCount();
            int r = count - 1;
            while (r >= 0) {
                this.table.removeRow(r);
                --r;
            }
            String datasetName = "";
            String projectName = "";
            long oldDatasetID = 0L;
            long datasetID = 0L;
            long oldProjectID = 0L;
            long projectID = 0L;
            while (rs.next()) {
                datasetID = rs.getLong("datasetID");
                projectID = rs.getLong("projectID");
                if (oldDatasetID != datasetID) {
                    oldDatasetID = datasetID;
                    try {
                        datasetName = this.store.getTarget(Dataset.class, rs.getLong("datasetID")).getName().getValue();
                    }
                    catch (Exception e) {
                        datasetName = "unknown";
                        this.displayAccessError();
                    }
                }
                if (oldProjectID != projectID) {
                    oldProjectID = projectID;
                    try {
                        projectName = this.store.getProject(rs.getLong("projectID")).getName().getValue();
                    }
                    catch (Exception e) {
                        projectName = "unknown";
                        this.displayAccessError();
                    }
                }
                String dayString = HistoryTable.db.day.format(rs.getObject("date"));
                String hourString = HistoryTable.db.hour.format(rs.getObject("date"));
                if (HistoryTable.db.day.format(new Date()).equals(dayString)) {
                    dayString = "Today";
                }
                if (HistoryTable.db.day.format(db.getYesterday()).equals(dayString)) {
                    dayString = "Yesterday";
                }
                Vector<Object> row = new Vector<Object>();
                row.add(rs.getObject("filename"));
                row.add(String.valueOf(projectName) + "/" + datasetName);
                row.add(String.valueOf(dayString) + " " + hourString);
                row.add(rs.getObject("status"));
                row.add(rs.getObject("filepath"));
                row.add(rs.getLong("datasetID"));
                row.add(rs.getLong("projectID"));
                this.table.addRow(row);
                this.table.fireTableDataChanged();
                this.unknownProjectDatasetFlag = false;
            }
            if (rs.getFetchSize() > 0) {
                this.reimportBtn.setEnabled(true);
            } else {
                this.reimportBtn.setEnabled(false);
            }
            rs.close();
        }
        catch (SQLException ex3) {
            log.error((Object)"SQL exception.", (Throwable)ex3);
        }
        catch (NullPointerException ex4) {
            log.error((Object)"Null pointer exception.", (Throwable)ex4);
        }
    }

    public ResultSet getCurrentResultSet() {
        return null;
    }

    private void displayAccessError() {
        if (this.unknownProjectDatasetFlag) {
            return;
        }
        this.unknownProjectDatasetFlag = true;
        JOptionPane.showMessageDialog(null, "We were not able to retrieve the project/dataset for\none or more of the imports in this history selection.\nThe most like cause is that the original project or\ndataset was deleted.\n\nAs a result, the imported items in question cannot be\nreimported automatically using the \"reimport\" button.\n\nClick OK to continue.", "Warning", 0);
    }

    private void updateOutlookBar() {
        GregorianCalendar newCal = new GregorianCalendar();
        int dayOfWeek = newCal.get(7);
        int dayOfMonth = newCal.get(5);
        DefaultListModel today = db.getImportListByDate(db.getDaysBefore(new Date(), 1), new Date());
        this.outlookBar.updatePanelList(this.todayList, this.outlookBar.today, today);
        DefaultListModel yesterday = db.getImportListByDate(new Date(), db.getYesterday());
        this.outlookBar.updatePanelList(this.yesterdayList, this.outlookBar.yesterday, yesterday);
        DefaultListModel thisWeek = db.getImportListByDate(db.getDaysBefore(new Date(), 1), db.getDaysBefore(new Date(), -dayOfWeek));
        this.outlookBar.updatePanelList(this.thisWeekList, this.outlookBar.thisWeek, thisWeek);
        DefaultListModel lastWeek = db.getImportListByDate(db.getDaysBefore(new Date(), -dayOfWeek), db.getDaysBefore(new Date(), -(dayOfWeek + 7)));
        this.outlookBar.updatePanelList(this.lastWeekList, this.outlookBar.lastWeek, lastWeek);
        DefaultListModel thisMonth = db.getImportListByDate(db.getDaysBefore(new Date(), 1), db.getDaysBefore(new Date(), -dayOfMonth));
        this.outlookBar.updatePanelList(this.thisMonthList, this.outlookBar.thisMonth, thisMonth);
    }

    private void getQuickHistory(Integer importKey) {
        this.getFileQuery(importKey, this.experimenterID, null, null, null);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.searchBtn || src == this.doneCheckBox || src == this.failedCheckBox || src == this.invalidCheckBox || src == this.pendingCheckBox) {
            this.getFileQuery(-1, this.experimenterID, this.searchField.getText(), this.fromDate.getDate(), this.toDate.getDate());
        }
        if (src == this.clearBtn) {
            this.ClearHistory();
        }
        if (src == this.reimportBtn) {
            this.notifyObservers("REIMPORT", null);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("QUICK_HISTORY")) {
            this.getQuickHistory((Integer)e.getNewValue());
        }
        if (prop.equals("date")) {
            this.getFileQuery(-1, this.experimenterID, this.searchField.getText(), this.fromDate.getDate(), this.toDate.getDate());
        }
    }

    public void update(IObservable importLibrary, Object message, Object[] args) {
        this.getExperimenterID();
        if (this.experimenterID != -1L && message == "LOGGED_IN" || message == "QUICKBAR_UPDATE") {
            this.updateOutlookBar();
        }
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(Object message, Object[] args) {
        for (IObserver observer : this.observers) {
            observer.update(this, message, args);
        }
    }

    class HistoryTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"File Name", "Project/Dataset", "Import Date/Time", "Status", "FilePath", "DatasetID", "ProjectID"};

        HistoryTableModel() {
        }

        public void tableChanged(TableModelEvent arg0) {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public boolean rowSelectionAllowed() {
            return true;
        }
    }

    class LeftDotRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        LeftDotRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int availableWidth = table.getColumnModel().getColumn(column).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            String cellText = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                String dots = "...";
                int textWidth = fm.stringWidth(dots);
                int nChars = cellText.length() - 1;
                while (nChars > 0) {
                    if ((textWidth += fm.charWidth(cellText.charAt(nChars))) > availableWidth) break;
                    --nChars;
                }
                this.setText(String.valueOf(dots) + cellText.substring(nChars + 1));
            }
            this.setFont(UIManager.getFont("TableCell.font"));
            return this;
        }
    }

    public class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(BorderFactory.createLineBorder(new Color(0xE0E0E0)));
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
            this.setFont(this.getFont().deriveFont(1));
            this.setHorizontalAlignment(0);
            this.setText(value.toString());
            this.setOpaque(true);
            this.setToolTipText((String)value);
            this.setEnabled(table == null || table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class TextCellCenter
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setFont(UIManager.getFont("TableCell.font"));
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

