/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import omero.model.Dataset;
import omero.model.IObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFixture {
    Log log = LogFactory.getLog(ImportFixture.class);
    private String user;
    private String pass;
    private String host;
    private String port;
    private OMEROMetadataStoreClient store;
    private OMEROWrapper reader;
    private ImportLibrary library;
    private Map<File, Dataset> fads = new HashMap<File, Dataset>();

    public ImportFixture(OMEROMetadataStoreClient store) {
        this(store, new OMEROWrapper());
    }

    public ImportFixture(OMEROMetadataStoreClient store, OMEROWrapper reader) {
        this.store = store;
        this.reader = reader;
    }

    public ImportFixture put(File file, Dataset ds) {
        if (file == null || ds == null) {
            throw new RuntimeException("Arguments cannot be null.");
        }
        this.fads.put(file, ds);
        return this;
    }

    public ImportFixture putAll(Map<File, Dataset> map) {
        for (File f : map.keySet()) {
            this.put(f, map.get(f));
        }
        return this;
    }

    public void setUp() throws Exception {
        this.library = new ImportLibrary(this.store, this.reader);
    }

    public void tearDown() {
        this.fads = null;
        this.store = null;
        this.library = null;
        try {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.reader = null;
        }
    }

    public void doImport(ImportLibrary.Step step) throws Exception {
        if (step == null) {
            throw new Exception("Step may not be null.");
        }
        for (File file : this.fads.keySet()) {
            String fileName = file.getAbsolutePath();
            this.library.setTarget((IObject)this.fads.get(file));
            this.library.open(fileName);
            this.library.importImage(file, 0, 0, 1, file.getAbsolutePath(), null, false, null);
        }
    }

    public void doImport() throws Exception {
        this.doImport(new ImportLibrary.Step(){

            public void step(int series, int n) {
            }
        });
    }
}

