/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import loci.formats.IFormatReader;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Image;
import omero.model.Pixels;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PixelsProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(PixelsProcessor.class);
    private Timestamp earliestMTime;
    private IFormatReader reader;

    public void process(IObjectContainerStore store) throws ModelException {
        this.reader = store.getReader();
        List<IObjectContainer> containers = store.getIObjectContainers(Pixels.class);
        for (IObjectContainer container : containers) {
            Integer imageIndex = (Integer)container.indexes.get("imageIndex");
            LSID imageLSID = new LSID(Image.class, new int[]{imageIndex});
            Image image = (Image)store.getSourceObject(imageLSID);
            Pixels pixels = (Pixels)container.sourceObject;
            Double[] physicalPixelSizes = store.getUserSpecifiedPhysicalPixelSizes();
            if (physicalPixelSizes != null) {
                if (physicalPixelSizes[0] != null && pixels.getPhysicalSizeX() == null) {
                    pixels.setPhysicalSizeX(rtypes.rdouble((double)physicalPixelSizes[0]));
                }
                if (physicalPixelSizes[1] != null && pixels.getPhysicalSizeY() == null) {
                    pixels.setPhysicalSizeY(rtypes.rdouble((double)physicalPixelSizes[1]));
                }
                if (physicalPixelSizes[2] != null && pixels.getPhysicalSizeZ() == null) {
                    pixels.setPhysicalSizeZ(rtypes.rdouble((double)physicalPixelSizes[2]));
                }
            }
            if (image == null) {
                LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
                indexes.put("imageIndex", imageIndex);
                container = store.getIObjectContainer(Image.class, indexes);
                image = (Image)container.sourceObject;
            }
            if (image.getAcquisitionDate() == null) {
                if (this.earliestMTime == null) {
                    String[] fileNameList = store.getReader().getUsedFiles();
                    long mtime = Long.MAX_VALUE;
                    int j = 0;
                    while (j < fileNameList.length) {
                        File f = new File(fileNameList[j]);
                        if (f.lastModified() < mtime) {
                            mtime = f.lastModified();
                        }
                        ++j;
                    }
                    this.earliestMTime = new Timestamp(mtime);
                }
                image.setAcquisitionDate(rtypes.rtime((Date)this.earliestMTime));
            }
            String userSpecifiedName = store.getUserSpecifiedImageName();
            String saveName = "";
            if (image.getName() == null || image.getName().getValue().trim().length() == 0) {
                saveName = userSpecifiedName;
                if (this.reader.getSeriesCount() > 1) {
                    saveName = String.valueOf(saveName) + " [" + imageIndex + "]";
                }
            } else {
                saveName = image.getName().getValue();
            }
            image.setName(rtypes.rstring((String)saveName));
            String userSpecifiedDescription = store.getUserSpecifiedImageDescription();
            if (userSpecifiedDescription == null) continue;
            image.setDescription(rtypes.rstring((String)userSpecifiedDescription));
        }
    }
}

