/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import IceInternal.Instance;
import IceInternal.Time;
import IceInternal.TimerTask;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Timer
extends Thread {
    private final SortedSet<Token> _tokens = new TreeSet<Token>();
    private final Map<TimerTask, Token> _tasks = new HashMap<TimerTask, Token>();
    private Instance _instance;
    private long _wakeUpTime = Long.MAX_VALUE;
    private int _tokenId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _destroy() {
        Timer timer = this;
        synchronized (timer) {
            if (this._instance == null) {
                return;
            }
            this._instance = null;
            this.notify();
            this._tokens.clear();
            this._tasks.clear();
        }
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized void schedule(TimerTask task, long delay) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        Token token = new Token(Time.currentMonotonicTimeMillis() + delay, ++this._tokenId, 0L, task);
        Token previous = this._tasks.put(task, token);
        assert (previous == null);
        this._tokens.add(token);
        if (token.scheduledTime < this._wakeUpTime) {
            this.notify();
        }
    }

    public synchronized void scheduleRepeated(TimerTask task, long period) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        Token token = new Token(Time.currentMonotonicTimeMillis() + period, ++this._tokenId, period, task);
        Token previous = this._tasks.put(task, token);
        assert (previous == null);
        this._tokens.add(token);
        if (token.scheduledTime < this._wakeUpTime) {
            this.notify();
        }
    }

    public synchronized boolean cancel(TimerTask task) {
        if (this._instance == null) {
            return false;
        }
        Token token = this._tasks.remove(task);
        if (token == null) {
            return false;
        }
        this._tokens.remove(token);
        return true;
    }

    Timer(Instance instance) {
        this._instance = instance;
        String threadName = this._instance.initializationData().properties.getProperty("Ice.ProgramName");
        if (threadName.length() > 0) {
            threadName = threadName + "-";
        }
        this.setName(threadName + "Ice.Timer");
        this.start();
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._instance == null);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Token token = null;
        while (true) {
            Timer timer = this;
            synchronized (timer) {
                if (this._instance != null && token != null && token.delay > 0L && this._tasks.containsKey(token.task)) {
                    token.scheduledTime = Time.currentMonotonicTimeMillis() + token.delay;
                    this._tokens.add(token);
                }
                token = null;
                if (this._instance == null) {
                    break;
                }
                if (this._tokens.isEmpty()) {
                    this._wakeUpTime = Long.MAX_VALUE;
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                        break;
                    }
                }
                if (this._instance == null) {
                    break;
                }
                block14: while (!this._tokens.isEmpty() && this._instance != null) {
                    long now = Time.currentMonotonicTimeMillis();
                    Token first = this._tokens.first();
                    if (first.scheduledTime <= now) {
                        this._tokens.remove(first);
                        token = first;
                        if (token.delay != 0L) break;
                        this._tasks.remove(token.task);
                        break;
                    }
                    this._wakeUpTime = first.scheduledTime;
                    while (true) {
                        try {
                            this.wait(first.scheduledTime - now);
                            continue block14;
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                        break;
                    }
                }
                if (this._instance == null) {
                    break;
                }
            }
            if (token == null) continue;
            try {
                token.task.runTimerTask();
            }
            catch (Exception ex) {
                Timer timer2 = this;
                synchronized (timer2) {
                    if (this._instance != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        pw.flush();
                        String s = "unexpected exception from task run method in timer thread:\n" + sw.toString();
                        this._instance.initializationData().logger.error(s);
                    }
                }
            }
        }
    }

    private static class Token
    implements Comparable {
        long scheduledTime;
        int id;
        long delay;
        TimerTask task;

        public Token(long scheduledTime, int id, long delay, TimerTask task) {
            this.scheduledTime = scheduledTime;
            this.id = id;
            this.delay = delay;
            this.task = task;
        }

        public int compareTo(Object o) {
            Token r = (Token)o;
            if (this.scheduledTime < r.scheduledTime) {
                return -1;
            }
            if (this.scheduledTime > r.scheduledTime) {
                return 1;
            }
            if (this.id < r.id) {
                return -1;
            }
            if (this.id > r.id) {
                return 1;
            }
            return 0;
        }
    }
}

