/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RBool;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Dataset;
import omero.model.DatasetImageLink;
import omero.model.DatasetImageLinkI;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Experiment;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.ImageAnnotationLinkI;
import omero.model.ImagingEnvironment;
import omero.model.Instrument;
import omero.model.ObjectiveSettings;
import omero.model.Pixels;
import omero.model.StageLabel;
import omero.model.WellSample;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageI
extends Image
implements ModelBased {
    public static final String ACQUISITIONDATE = "ome.model.core.Image_acquisitionDate";
    public static final String ARCHIVED = "ome.model.core.Image_archived";
    public static final String IMAGINGENVIRONMENT = "ome.model.core.Image_imagingEnvironment";
    public static final String OBJECTIVESETTINGS = "ome.model.core.Image_objectiveSettings";
    public static final String INSTRUMENT = "ome.model.core.Image_instrument";
    public static final String STAGELABEL = "ome.model.core.Image_stageLabel";
    public static final String EXPERIMENT = "ome.model.core.Image_experiment";
    public static final String PIXELS = "ome.model.core.Image_pixels";
    public static final String WELLSAMPLES = "ome.model.core.Image_wellSamples";
    public static final String DATASETLINKS = "ome.model.core.Image_datasetLinks";
    public static final String ANNOTATIONLINKS = "ome.model.core.Image_annotationLinks";
    public static final String NAME = "ome.model.core.Image_name";
    public static final String DESCRIPTION = "ome.model.core.Image_description";
    public static final String DETAILS = "ome.model.core.Image_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.pixelsSeq = new ArrayList();
            this.pixelsLoaded = true;
        } else {
            this.pixelsSeq = null;
            this.pixelsLoaded = false;
        }
        if (load) {
            this.wellSamplesSeq = new ArrayList();
            this.wellSamplesLoaded = true;
        } else {
            this.wellSamplesSeq = null;
            this.wellSamplesLoaded = false;
        }
        if (load) {
            this.datasetLinksSeq = new ArrayList();
            this.datasetLinksLoaded = true;
        } else {
            this.datasetLinksSeq = null;
            this.datasetLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public ImageI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ImageI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ImageI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadAcquisitionDate();
        this.unloadArchived();
        this.unloadImagingEnvironment();
        this.unloadObjectiveSettings();
        this.unloadInstrument();
        this.unloadStageLabel();
        this.unloadExperiment();
        this.unloadPixels();
        this.unloadWellSamples();
        this.unloadDatasetLinks();
        this.unloadAnnotationLinks();
        this.unloadName();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ImageI copy = new ImageI();
        copy.id = this.id;
        copy.version = this.version;
        copy.acquisitionDate = this.acquisitionDate;
        copy.archived = this.archived;
        copy.imagingEnvironment = this.imagingEnvironment == null ? null : (ImagingEnvironment)this.imagingEnvironment.proxy();
        copy.objectiveSettings = this.objectiveSettings == null ? null : (ObjectiveSettings)this.objectiveSettings.proxy();
        copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        copy.stageLabel = this.stageLabel == null ? null : (StageLabel)this.stageLabel.proxy();
        Experiment experiment = copy.experiment = this.experiment == null ? null : (Experiment)this.experiment.proxy();
        if (!this.pixelsLoaded) {
            copy.pixelsLoaded = false;
            copy.pixelsSeq = null;
        } else {
            copy.pixelsLoaded = true;
            copy.pixelsSeq = new ArrayList<Pixels>();
            for (IObject item : this.pixelsSeq) {
                copy.pixelsSeq.add(item == null ? null : (Pixels)item.proxy());
            }
        }
        if (!this.wellSamplesLoaded) {
            copy.wellSamplesLoaded = false;
            copy.wellSamplesSeq = null;
        } else {
            copy.wellSamplesLoaded = true;
            copy.wellSamplesSeq = new ArrayList<WellSample>();
            for (IObject item : this.wellSamplesSeq) {
                copy.wellSamplesSeq.add(item == null ? null : (WellSample)item.proxy());
            }
        }
        if (!this.datasetLinksLoaded) {
            copy.datasetLinksLoaded = false;
            copy.datasetLinksSeq = null;
        } else {
            copy.datasetLinksLoaded = true;
            copy.datasetLinksSeq = new ArrayList<DatasetImageLink>();
            for (IObject item : this.datasetLinksSeq) {
                copy.datasetLinksSeq.add(item == null ? null : (DatasetImageLink)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<ImageAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (ImageAnnotationLink)item.proxy());
            }
        }
        copy.name = this.name;
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ImageI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadAcquisitionDate() {
        this.acquisitionDate = null;
    }

    @Override
    public RTime getAcquisitionDate(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.acquisitionDate;
    }

    @Override
    public void setAcquisitionDate(RTime acquisitionDate, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.acquisitionDate = acquisitionDate;
    }

    private void copyAcquisitionDate(ome.model.core.Image source, IceMapper mapper) {
        this.acquisitionDate = source.getAcquisitionDate() == null ? null : rtypes.rtime(source.getAcquisitionDate().getTime());
    }

    private void fillAcquisitionDate(ome.model.core.Image target, IceMapper mapper) {
        try {
            target.setAcquisitionDate((Timestamp)mapper.fromRType(this.getAcquisitionDate()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadArchived() {
        this.archived = null;
    }

    @Override
    public RBool getArchived(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.archived;
    }

    @Override
    public void setArchived(RBool archived, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.archived = archived;
    }

    private void copyArchived(ome.model.core.Image source, IceMapper mapper) {
        this.archived = source.getArchived() == null ? null : rtypes.rbool(source.getArchived());
    }

    private void fillArchived(ome.model.core.Image target, IceMapper mapper) {
        try {
            target.setArchived((Boolean)mapper.fromRType(this.getArchived()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadImagingEnvironment() {
        this.imagingEnvironment = null;
    }

    @Override
    public ImagingEnvironment getImagingEnvironment(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.imagingEnvironment;
    }

    @Override
    public void setImagingEnvironment(ImagingEnvironment imagingEnvironment, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.imagingEnvironment = imagingEnvironment;
    }

    private void copyImagingEnvironment(ome.model.core.Image source, IceMapper mapper) {
        this.imagingEnvironment = (ImagingEnvironment)mapper.findTarget(source.getImagingEnvironment());
    }

    private void fillImagingEnvironment(ome.model.core.Image target, IceMapper mapper) {
        target.putAt(IMAGINGENVIRONMENT, mapper.reverse((ModelBased)((Object)this.getImagingEnvironment())));
    }

    public void unloadObjectiveSettings() {
        this.objectiveSettings = null;
    }

    @Override
    public ObjectiveSettings getObjectiveSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.objectiveSettings;
    }

    @Override
    public void setObjectiveSettings(ObjectiveSettings objectiveSettings, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.objectiveSettings = objectiveSettings;
    }

    private void copyObjectiveSettings(ome.model.core.Image source, IceMapper mapper) {
        this.objectiveSettings = (ObjectiveSettings)mapper.findTarget(source.getObjectiveSettings());
    }

    private void fillObjectiveSettings(ome.model.core.Image target, IceMapper mapper) {
        target.putAt(OBJECTIVESETTINGS, mapper.reverse((ModelBased)((Object)this.getObjectiveSettings())));
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.core.Image source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.core.Image target, IceMapper mapper) {
        target.putAt(INSTRUMENT, mapper.reverse((ModelBased)((Object)this.getInstrument())));
    }

    public void unloadStageLabel() {
        this.stageLabel = null;
    }

    @Override
    public StageLabel getStageLabel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.stageLabel;
    }

    @Override
    public void setStageLabel(StageLabel stageLabel, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.stageLabel = stageLabel;
    }

    private void copyStageLabel(ome.model.core.Image source, IceMapper mapper) {
        this.stageLabel = (StageLabel)mapper.findTarget(source.getStageLabel());
    }

    private void fillStageLabel(ome.model.core.Image target, IceMapper mapper) {
        target.putAt(STAGELABEL, mapper.reverse((ModelBased)((Object)this.getStageLabel())));
    }

    public void unloadExperiment() {
        this.experiment = null;
    }

    @Override
    public Experiment getExperiment(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.experiment;
    }

    @Override
    public void setExperiment(Experiment experiment, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.experiment = experiment;
    }

    private void copyExperiment(ome.model.core.Image source, IceMapper mapper) {
        this.experiment = (Experiment)mapper.findTarget(source.getExperiment());
    }

    private void fillExperiment(ome.model.core.Image target, IceMapper mapper) {
        target.putAt(EXPERIMENT, mapper.reverse((ModelBased)((Object)this.getExperiment())));
    }

    @Override
    public void unloadPixels(Current current) {
        this.pixelsLoaded = false;
        this.pixelsSeq = null;
    }

    protected List getPixels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pixelsSeq;
    }

    protected void setPixels(List pixels, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pixelsSeq = pixels == null ? new ArrayList() : new ArrayList(pixels);
        this.pixelsLoaded = pixels != null;
    }

    private void copyPixels(ome.model.core.Image source, IceMapper mapper) {
        this.setPixels((List)mapper.findCollection((Collection)source.retrieve(PIXELS)), null);
    }

    private void fillPixels(ome.model.core.Image target, IceMapper mapper) {
        if (this.pixelsLoaded) {
            target.putAt(PIXELS, mapper.reverse(this.pixelsSeq, List.class));
        } else {
            target.putAt(PIXELS, null);
        }
    }

    public boolean isPixelsLoaded() {
        return this.pixelsLoaded;
    }

    @Override
    public int sizeOfPixels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            return -1;
        }
        return this.pixelsSeq.size();
    }

    public List copyPixels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        ArrayList result = new ArrayList(this.pixelsSeq);
        return result;
    }

    public Iterator iteratePixels() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        return this.pixelsSeq.iterator();
    }

    @Override
    public void addPixels(Pixels target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        this.pixelsSeq.add(target);
        target.setImage(this);
    }

    @Override
    public void addAllPixelsSet(List<Pixels> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        this.pixelsSeq.addAll(targets);
        for (Pixels target : targets) {
            target.setImage(this);
        }
    }

    @Override
    public void removePixels(Pixels target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        this.pixelsSeq.remove(target);
        target.setImage(null);
    }

    public void removePixelsSet(Collection<Pixels> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        for (Pixels elt : targets) {
            elt.setImage(null);
            this.pixelsSeq.remove(elt);
        }
    }

    @Override
    public void clearPixels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        for (Pixels elt : this.pixelsSeq) {
            elt.setImage(null);
        }
        this.pixelsSeq.clear();
    }

    @Override
    public void reloadPixels(Image toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.pixelsLoaded) {
            throw new ClientError("Cannot reload active collection: pixelsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Pixels> copy = toCopy.copyPixels();
        for (Pixels elt : copy) {
            elt.setImage(this);
        }
        this.pixelsSeq = new ArrayList<Pixels>(copy);
        toCopy.unloadPixels();
        this.pixelsLoaded = true;
    }

    @Override
    public Pixels getPixels(int index, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        return (Pixels)this.pixelsSeq.get(index);
    }

    @Override
    public void setPixels(int index, Pixels element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        this.pixelsSeq.set(index, element);
    }

    @Override
    public Pixels getPrimaryPixels(Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        return (Pixels)this.pixelsSeq.get(0);
    }

    @Override
    public Pixels setPrimaryPixels(Pixels element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.pixelsLoaded) {
            this.throwNullCollectionException("pixelsSeq");
        }
        int index = this.pixelsSeq.indexOf(element);
        Pixels old = (Pixels)this.pixelsSeq.get(0);
        this.pixelsSeq.set(index, old);
        this.pixelsSeq.set(0, element);
        return old;
    }

    @Override
    public void unloadWellSamples(Current current) {
        this.wellSamplesLoaded = false;
        this.wellSamplesSeq = null;
    }

    protected List getWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wellSamplesSeq;
    }

    protected void setWellSamples(List wellSamples, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wellSamplesSeq = wellSamples == null ? new ArrayList() : new ArrayList(wellSamples);
        this.wellSamplesLoaded = wellSamples != null;
    }

    private void copyWellSamples(ome.model.core.Image source, IceMapper mapper) {
        this.setWellSamples((List)mapper.findCollection((Collection)source.retrieve(WELLSAMPLES)), null);
    }

    private void fillWellSamples(ome.model.core.Image target, IceMapper mapper) {
        if (this.wellSamplesLoaded) {
            target.putAt(WELLSAMPLES, mapper.reverse(this.wellSamplesSeq, Set.class));
        } else {
            target.putAt(WELLSAMPLES, null);
        }
    }

    public boolean isWellSamplesLoaded() {
        return this.wellSamplesLoaded;
    }

    @Override
    public int sizeOfWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            return -1;
        }
        return this.wellSamplesSeq.size();
    }

    public List copyWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        ArrayList result = new ArrayList(this.wellSamplesSeq);
        return result;
    }

    public Iterator iterateWellSamples() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        return this.wellSamplesSeq.iterator();
    }

    @Override
    public void addWellSample(WellSample target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        this.wellSamplesSeq.add(target);
        target.setImage(this);
    }

    @Override
    public void addAllWellSampleSet(List<WellSample> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        this.wellSamplesSeq.addAll(targets);
        for (WellSample target : targets) {
            target.setImage(this);
        }
    }

    @Override
    public void removeWellSample(WellSample target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        this.wellSamplesSeq.remove(target);
        target.setImage(null);
    }

    public void removeWellSampleSet(Collection<WellSample> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        for (WellSample elt : targets) {
            elt.setImage(null);
            this.wellSamplesSeq.remove(elt);
        }
    }

    @Override
    public void clearWellSamples(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellSamplesLoaded) {
            this.throwNullCollectionException("wellSamplesSeq");
        }
        for (WellSample elt : this.wellSamplesSeq) {
            elt.setImage(null);
        }
        this.wellSamplesSeq.clear();
    }

    @Override
    public void reloadWellSamples(Image toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.wellSamplesLoaded) {
            throw new ClientError("Cannot reload active collection: wellSamplesSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<WellSample> copy = toCopy.copyWellSamples();
        for (WellSample elt : copy) {
            elt.setImage(this);
        }
        this.wellSamplesSeq = new ArrayList<WellSample>(copy);
        toCopy.unloadWellSamples();
        this.wellSamplesLoaded = true;
    }

    @Override
    public void unloadDatasetLinks(Current current) {
        this.datasetLinksLoaded = false;
        this.datasetLinksSeq = null;
    }

    protected List getDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.datasetLinksSeq;
    }

    protected void setDatasetLinks(List datasetLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.datasetLinksSeq = datasetLinks == null ? new ArrayList() : new ArrayList(datasetLinks);
        this.datasetLinksLoaded = datasetLinks != null;
    }

    private void copyDatasetLinks(ome.model.core.Image source, IceMapper mapper) {
        this.setDatasetLinks((List)mapper.findCollection((Collection)source.retrieve(DATASETLINKS)), null);
        this.datasetLinksCountPerOwner = source.getDatasetLinksCountPerOwner();
    }

    private void fillDatasetLinks(ome.model.core.Image target, IceMapper mapper) {
        if (this.datasetLinksLoaded) {
            target.putAt(DATASETLINKS, mapper.reverse(this.datasetLinksSeq, Set.class));
        } else {
            target.putAt(DATASETLINKS, null);
        }
    }

    public boolean isDatasetLinksLoaded() {
        return this.datasetLinksLoaded;
    }

    @Override
    public int sizeOfDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            return -1;
        }
        return this.datasetLinksSeq.size();
    }

    public List copyDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        ArrayList result = new ArrayList(this.datasetLinksSeq);
        return result;
    }

    public Iterator iterateDatasetLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        return this.datasetLinksSeq.iterator();
    }

    @Override
    public void addDatasetImageLink(DatasetImageLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.add(target);
        target.setChild(this);
    }

    @Override
    public void addAllDatasetImageLinkSet(List<DatasetImageLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.addAll(targets);
        for (DatasetImageLink target : targets) {
            target.setChild(this);
        }
    }

    @Override
    public void removeDatasetImageLink(DatasetImageLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.remove(target);
        target.setChild(null);
    }

    public void removeDatasetImageLinkSet(Collection<DatasetImageLink> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        for (DatasetImageLink elt : targets) {
            elt.setChild(null);
            this.datasetLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearDatasetLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        for (DatasetImageLink elt : this.datasetLinksSeq) {
            elt.setChild(null);
        }
        this.datasetLinksSeq.clear();
    }

    @Override
    public void reloadDatasetLinks(Image toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.datasetLinksLoaded) {
            throw new ClientError("Cannot reload active collection: datasetLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<DatasetImageLink> copy = toCopy.copyDatasetLinks();
        for (DatasetImageLink elt : copy) {
            elt.setChild(this);
        }
        this.datasetLinksSeq = new ArrayList<DatasetImageLink>(copy);
        toCopy.unloadDatasetLinks();
        this.datasetLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getDatasetLinksCountPerOwner(Current current) {
        return this.datasetLinksCountPerOwner;
    }

    @Override
    public DatasetImageLink linkDataset(Dataset addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        DatasetImageLinkI link = new DatasetImageLinkI();
        link.link(addition, this);
        this.addDatasetImageLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addDatasetImageLinkToBoth(DatasetImageLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.add(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().addDatasetImageLinkToBoth(link, false);
        }
    }

    @Override
    public List<DatasetImageLink> findDatasetImageLink(Dataset removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        ArrayList<DatasetImageLink> result = new ArrayList<DatasetImageLink>();
        for (DatasetImageLink link : this.datasetLinksSeq) {
            if (link.getParent() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkDataset(Dataset removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        List<DatasetImageLink> toRemove = this.findDatasetImageLink(removal);
        Iterator<DatasetImageLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeDatasetImageLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeDatasetImageLinkFromBoth(DatasetImageLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("datasetLinksSeq");
        }
        this.datasetLinksSeq.remove(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().removeDatasetImageLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Dataset> linkedDatasetList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.datasetLinksLoaded) {
            this.throwNullCollectionException("DatasetLinks");
        }
        ArrayList<Dataset> linked = new ArrayList<Dataset>();
        for (DatasetImageLink link : this.datasetLinksSeq) {
            linked.add(link.getParent());
        }
        return linked;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.core.Image source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.core.Image target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addImageAnnotationLink(ImageAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllImageAnnotationLinkSet(List<ImageAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (ImageAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeImageAnnotationLink(ImageAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    public void removeImageAnnotationLinkSet(Collection<ImageAnnotationLink> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ImageAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (ImageAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Image toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ImageAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (ImageAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<ImageAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public ImageAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ImageAnnotationLinkI link = new ImageAnnotationLinkI();
        link.link(this, addition);
        this.addImageAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addImageAnnotationLinkToBoth(ImageAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<ImageAnnotationLink> findImageAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<ImageAnnotationLink> result = new ArrayList<ImageAnnotationLink>();
        for (ImageAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<ImageAnnotationLink> toRemove = this.findImageAnnotationLink(removal);
        Iterator<ImageAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeImageAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeImageAnnotationLinkFromBoth(ImageAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (ImageAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.core.Image source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.core.Image target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.core.Image source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.core.Image target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.core.Image) {
            ome.model.core.Image source = (ome.model.core.Image)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyAcquisitionDate(source, mapper);
                this.copyArchived(source, mapper);
                this.copyImagingEnvironment(source, mapper);
                this.copyObjectiveSettings(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyStageLabel(source, mapper);
                this.copyExperiment(source, mapper);
                this.copyPixels(source, mapper);
                this.copyWellSamples(source, mapper);
                this.copyDatasetLinks(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyName(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Image cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.core.Image target = new ome.model.core.Image();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillAcquisitionDate(target, mapper);
            this.fillArchived(target, mapper);
            this.fillImagingEnvironment(target, mapper);
            this.fillObjectiveSettings(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillStageLabel(target, mapper);
            this.fillExperiment(target, mapper);
            this.fillPixels(target, mapper);
            this.fillWellSamples(target, mapper);
            this.fillDatasetLinks(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillName(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<ImageI> cast(List list) {
        return list;
    }
}

