/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import omero.RString;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.GroupExperimenterMap;
import omero.rtypes;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.SetMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupData
extends DataObject {
    public static final String NAME = "ome.model.meta.ExperimenterGroup_name";
    public static final String DESCRIPTION = "ome.model.meta.ExperimenterGroup_description";
    public static final String GROUP_EXPERIMENTER_MAP = "ome.model.meta.ExperimenterGroup_groupExperimenterMap";
    private Set experimenters;

    public GroupData() {
        this.setDirty(true);
        this.setValue(new ExperimenterGroupI());
    }

    public GroupData(ExperimenterGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Annotation cannot null.");
        }
        this.setValue(group);
    }

    public String getName() {
        RString n = this.asGroup().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been be null");
        }
        return n.getValue();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asGroup().setName(rtypes.rstring(name));
    }

    public Set getExperimenters() {
        if (this.experimenters == null && this.asGroup().sizeOfGroupExperimenterMap() >= 0) {
            this.experimenters = new HashSet();
            List<GroupExperimenterMap> links = this.asGroup().copyGroupExperimenterMap();
            for (GroupExperimenterMap link : links) {
                this.experimenters.add(new ExperimenterData(link.getChild()));
            }
        }
        return this.experimenters == null ? null : new HashSet(this.experimenters);
    }

    public void setExperimenters(Set<ExperimenterData> newValue) {
        Set currentValue = this.getExperimenters();
        SetMutator<ExperimenterData> m = new SetMutator<ExperimenterData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asGroup().unlinkExperimenter(m.nextDeletion().asExperimenter());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asGroup().linkExperimenter(m.nextAddition().asExperimenter());
        }
        this.experimenters = new HashSet<ExperimenterData>(m.result());
    }
}

