/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import omero.RInt;
import omero.RString;
import omero.model.Well;
import omero.model.WellI;
import omero.model.WellSample;
import omero.rtypes;
import pojos.DataObject;
import pojos.PlateData;
import pojos.SetMutator;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WellData
extends DataObject {
    private List<WellSampleData> wellSamples;
    private PlateData plate;

    public WellData() {
        this.setDirty(true);
        this.setValue(new WellI());
    }

    public WellData(Well well) {
        if (well == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(well);
    }

    public String getExternalDescription() {
        RString d = this.asWell().getExternalDescription();
        return d == null ? null : d.getValue();
    }

    public String getWellType() {
        RString t = this.asWell().getType();
        return t == null ? null : t.getValue();
    }

    public void setExternalDescription(String description) {
        this.setDirty(true);
        this.asWell().setExternalDescription(description == null ? null : rtypes.rstring(description));
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asWell().getAnnotationLinksCountPerOwner();
    }

    public Map<Long, Long> getReagentsCounts() {
        return this.asWell().getReagentLinksCountPerOwner();
    }

    public Integer getColumn() {
        RInt c = this.asWell().getColumn();
        return c == null ? null : Integer.valueOf(c.getValue());
    }

    public Integer getRow() {
        RInt r = this.asWell().getRow();
        return r == null ? null : Integer.valueOf(r.getValue());
    }

    public PlateData getPlate() {
        if (this.plate == null) {
            this.plate = new PlateData(this.asWell().getPlate());
        }
        return this.plate;
    }

    public List<WellSampleData> getWellSamples() {
        if (this.wellSamples == null && this.asWell().sizeOfWellSamples() >= 0) {
            this.wellSamples = new ArrayList<WellSampleData>();
            List<WellSample> samples = this.asWell().copyWellSamples();
            for (WellSample sample : samples) {
                this.wellSamples.add(new WellSampleData(sample));
            }
        }
        return this.wellSamples == null ? null : new ArrayList<WellSampleData>(this.wellSamples);
    }

    public void setWellSamples(List<WellSampleData> value) {
        List<WellSampleData> currentValue = this.getWellSamples();
        SetMutator<WellSampleData> m = new SetMutator<WellSampleData>(currentValue, value);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asWell().removeWellSample(m.nextDeletion().asWellSample());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asWell().addWellSample(m.nextAddition().asWellSample());
        }
        this.wellSamples = m.result();
    }
}

