function [c,v,mindist,t] = polysplitdiameter( vxs )
%[c,v] = polysplitdiameter( vxs )
%   Given an N*2 matrix of vertexes of a 2D polygon, find the centroid c of
%   the polygon and a unit vector v, such that the distance from c along v
%   to an edge of the polygon is minimised.

    numvxs = size(vxs,1);
    rvxs = [ vxs(2:numvxs,1) - vxs(1,1), vxs(2:numvxs,2) - vxs(1,2) ];
    centroids = (rvxs(1:numvxs-2,:) + rvxs(2:numvxs-1,:))*(1/3);
    areas = rvxs(1:numvxs-2,2) .* rvxs(2:numvxs-1,1) ...
            - rvxs(1:numvxs-2,1) .* rvxs(2:numvxs-1,2);
    rc = sum([centroids(:,1) .* areas, centroids(:,2) .* areas],1)/sum(areas);
    c = [ vxs(1,1) + rc(:,1), vxs(1,2) + rc(:,2) ];
    
    [mindist,t] = pointLineDistance( vxs([1,2],:), c );
    for i=2:numvxs-1
        [d,pp] = pointLineDistance( vxs([i,i+1],:), c );
        if d < mindist
            mindist = d;
            t = pp;
        end
    end
    v = t-c;
    n = norm(v);
    if n > 0
        v = v/n;
    end
end
