function bc = vec2bc( v, vxs, n )
%bc = vec2bc( v, vxs )
%   Convert a vector to barycentric coordinates with respect to the
%   triangle whose vertexes are the rows of the 3*3 matrix vxs.  n, if
%   supplied and nonempty, is a normal vector to the triangle.

    if nargin < 3
        n = [];
    end
    npts = size(v,1);
    bc = baryCoords( vxs, n, v + repmat( vxs(1,:), npts, 1 ) ) - repmat( [1,0,0], npts, 1 );
end
