function s = defaultFromStruct( s, d, fn )
%s = defaultFromStruct( s, d )
%   Set nonexistent fields of S in the cellarray FN of field names to the
%   corresponding values of D.  FN is optional and defaults to the set of
%   all fields of D.

    if nargin < 3
        fn = fieldnames(d);
    end
    for i = 1:length(fn)
        if ~isfield( s, fn{i} )
            s.(fn{i}) = d.(fn{i});
        end
    end
end
