function added = addpathif( d )
%added = addpathif( d )
%   As addpath(d), but returns true if and only if d was not already on the
%   path.  If d is already on the path, addpath(d) is still called, as this
%   has the effect of moving d to the beginning of the path.

    p = path();
    dpos = findinpath( d, p );
    if dpos ~= 1
        try
            addpath( d );
            if dpos==0
                fprintf( 1, '%s: Adding %s to head of command path.\n', mfilename(), d );
            else
                fprintf( 1, '%s: Moving %s to head of command path.\n', mfilename(), d );
            end
            added = true;
        catch
            fprintf( 1, 'Failed to add folder "%s" to command path.\n', d );
            added = false;
        end
    else
        added = true;
        fprintf( 1, '%s: %s is at the head of the path.\n', mfilename(), d );
    end
end
