function h = displayFileInDlg( filename, missingMessage, title )
    h = [];
    fid = fopen( filename, 'r' );
    if fid==-1
        if isempty(missingMessage)
            return;
        end
        text = missingMessage;
    else
        text = cell(0,1);
        i = 0;
        currentline = '';
        while true
            line = fgetl(fid);
            if (length(line)==1) && (line==-1)
                i = i+1;
                text{i} = currentline;
                break;
            end
            if isempty(line)
                i = i+1;
                text{i} = currentline;
                if ~isempty(currentline)
                    i = i+1;
                    text{i} = '';
                end
                currentline = '';
            else
                if isempty(currentline)
                    currentline = line;
                else
                    currentline = [currentline, ' ', line ];
                end
            end
        end
        fclose(fid);
    end
    h = openfig('textdisplayDlg','new','invisible');
    hd = guihandles(h);
    set( hd.thetext, 'String', text );
    set( h, 'Visible', 'on', 'Name', title );
end
