function olddir = trycd( newdir )
%olddir = trycd( newdir )
%   Like CD, but prints a warning if it fails instead of raising an
%   exception.  If it fails, olddir will be set to the empty string.
%
%   See also:
%       CD
    try
        olddir = cd( newdir );
    catch
        fprintf( 1, 'Cannot find folder %s.\n', newdir );
        olddir = '';
    end
end
