function ClusterControlAdd(varargin)
    %global ClusterControl_fig
    if isempty(findobj('Name','ClusterMonitor')) %if isempty(ClusterControl_fig)
        ClusterMonitor;
    end
    projectnamecell={};
    frombuffercell={};
    % Added 12/05/11
    Directory={}; %%%%
    arglist=varargin;
    if rem(length(arglist),2)~=0
        error('Please supply argument pairs, e.g. ''Project'',''motif'',''Pathname'',pwd');
    end
    for i=1:2:length(arglist)
        arg=lower(arglist{i});
        opt=arglist{i+1};
        switch arg
            case 'project'
                projectnamecell={opt};
            case 'frombuffer'
                frombuffercell=opt;
            % Added 12/05/11
            case 'directory'
                Directory=opt; %%%%
        end                
    end
    if isempty(frombuffercell)
        AddToClusterBuffer(projectnamecell,Directory);
        ClusterMonitor('StackPop','Add',projectnamecell)
    else
        ClusterMonitor('StackPop','Add',frombuffercell)
    end
end

function  AddToClusterBuffer(projectnamecell,Directory) % All changed 12/05/11
    % Download ClusterBuffer.txt from the cluster
    string=sprintf('pscp -pw %s "%s@%s:/%s%s/ClusterBuffer.txt" "%s"',...
        getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,fullfile(Directory,'ClusterBuffer.txt'));
    errors=unixcluster(string,sprintf('Copied %ss from ClusterBuffer.txt'),'copy','ClusterBuffer.txt');
    
    % Update ClusterBuffer.txt
    h=fopen(fullfile(Directory,'ClusterBuffer.txt'),'a');
    if h==-1
        error('Problem opening ClusterBuffer.txt');
    else
        for i=1:length(projectnamecell)
            fprintf(h,'%s\n',projectnamecell{i});
        end
        fclose(h);
        
        % Send new ClusterBuffer.txt to the cluster
        string=sprintf('pscp -pw %s "%s" "%s@%s:/%s%s/ClusterBuffer.txt"',...
                getpassword,fullfile(Directory,'ClusterBuffer.txt'),getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername);
        errors=unixcluster(string,sprintf('Copied %ss to ClusterBuffer.txt'),'copy','ClusterBuffer.txt');
        
        % Delete the local copy of ClusterBuffer.txt
        if ispc == 1
            [a,b]=system(sprintf('del %s',fullfile(Directory,'ClusterBuffer.txt')));
        else
            [a,b]=system(sprintf('rm %s',fullfile(Directory,'ClusterBuffer.txt')));
        end
        if a~=0
            disp(b);
        else
            disp(sprintf('deleted local temp copy of %s ',fullfile(Directory,'ClusterBuffer.txt')));
        end
    end
end
   
