function gv = cellVectorLocalToGlobal( m, lv )
%gv = cellVectorLocalToGlobal( m, lv )
%   LV contains one vector per finite element of M in local cell coordinates.
%   GV is the corresponding vector field expressed in global coordinates.
%   That is, for every i:
%
%       gv(i,:) = lv(i,:) * m.nodes(m.tricellvxs(i,:),:)
%
%   SEE ALSO: cellVectorGlobalToLocal

    gv = zeros(size(lv));
    for i=1:size(m.tricellvxs,1)
        gv(i,:) = lv(i,:) * m.nodes(m.tricellvxs(i,:),:);
    end
end
