function m = leaf_mgen_scale( m, varargin )
%m = leaf_mgen_scale( m, morphogen, scalefactor )
%   Scale the value of a given morphogen by a given amount.
%   Arguments:
%   1: The name or index of a morphogen.
%   2: The scale factor.
%   Examples:
%       m = leaf_mgen_scale( m, 'bpar', -1 );
%   See also: leaf_mgen_const.
%
%   Equivalent GUI operation: clicking the "Invert" button in the
%   "Morphogens" panel will scale the current morphogen by -1. There is not
%   yet a user interface for a general scale factor.
%
%   Topics: Morphogens.

    if isempty(m), return; end
    [ok1, morphogen, args] = getTypedArg( mfilename(), {'numeric','char'}, varargin );
    if ~ok1, return; end
    g = FindMorphogenIndex( m, morphogen, mfilename() );
    if isempty(g), return; end
    [ok2, amount, args] = getTypedArg( mfilename(), 'double', args );
    if ~ok2, return; end
    if ~isempty(args)
        fprintf( 1, '%d extra arguments to %s ignored.\n', ...
            length(args), mfilename() );
    end
    
    m.morphogens(:,g) = m.morphogens(:,g) * amount;
end
