function [cell,vorticity] = computeDisplacementStrains( cell, displacements )
%cell = computeDisplacementStrains( cell, displacements )
%   Set cell.displacementStrain equal to the strain at each Gauss point
%   resulting from the given displacements of the vertexes.

    SMALL_ROTATIONS_ASSUMED = false;
    numGaussPoints = size(cell.gnGlobal,3);
    vorticity = zeros(3,3,6);
    for i=1:numGaussPoints
        ui = cell.gnGlobal(:,:,i) * displacements;
        if SMALL_ROTATIONS_ASSUMED
            e = 0.5*(ui + ui');
          % e = 0.5*(ui + ui' + ui' * ui);
            if nargout > 0
                vort = 0.5*(ui-ui');
                vorticity(:,:,i) = eye(3) + vort; % [ vort(2,1), vort(1,3), vort(3,2) ];
            end
        else
            t = eye(3) + ui;
            [q,err] = extractRotation( t );
            e = t*q' - eye(3);
%             olde = 0.5*(ui + ui');
%             oldvort = 0.5*(ui-ui');
            if nargout > 0
                vorticity(:,:,i) = q;
            end
        end
        cell.displacementStrain(:,i) = make6vector( e );
    end
end
