function fe = standardFEpentahedron()
%fe = standardFEpentahedron()
%   Create a standard pentahedral FE.

    fe.vertexes = [ 0 0 -1
                    1 0 -1
                    0 1 -1
                    0 0 1
                    1 0 1
                    0 1 1 ];
    fe.edgeends = [ 1 2; 2 3; 3 1;
                    4 5; 5 6; 6 4;
                    1 4; 2 5; 3 6 ];
    fe.faceedges = [ 1 3 2 0;
                     4 5 6 0;
                     1 8 4 7;
                     2 9 5 8;
                     3 7 6 9 ];
    fe = completeFEconnections( fe );
end

