function isint = isinteractive( m )
%isint = isinteractive( m )
%   Determine if m is being processed interactively from within GFtbox.
%   This is deemed to be true if m.pictures is nonempty, m.pictures(1) is a
%   figure handle, and its tag is 'GFTwindow'.

    isint = (~isempty( m )) ...
            && (~isempty( m.pictures )) ...
            && ishandle( m.pictures(1) ) ...
            && strcmp( get( m.pictures(1), 'Tag' ), 'GFTwindow' );
end
