function [Uplanar,Ubending] = partitionCellStrain( U )
%[Uplanar,Ubending] = partitionCellStrain( U )
%   U is a 6*3 matrix of the displacements of the vertexes of a cell.
%   Rows 1:3 are one side, and rows 4:6 the other side.
%   This function returns a pair of such matrices, such that
%   U = Uplanar + Ubending
%   and Ubending has equal and opposite components for the top and bottom
%   vertexes of the cell.

    Uplanar = planarCellStrain( U );
    Ubending = U - Uplanar;
end
