function setGlobals()
    global gHaveGlobals;
    if ~isempty(gHaveGlobals)
        return;
    end
    gHaveGlobals = 1;
    
    global gMIN_MESHVERSION gMAX_MESHVERSION
    global gMIN_MGENVERSION gMAX_MGENVERSION

    global gOLD_K_PAR gOLD_K_PER gOLD_K_POL
    global gOLD_BEND_PAR gOLD_BEND_PER gOLD_BEND_POL
    global gOLD_ARREST gOLD_STRAINRET gOLD_THICKNESS gOLD_NUMRESERVEDMGENS

    global gNEW_KA_PAR gNEW_KA_PER gNEW_KB_PAR gNEW_KB_PER
    global gNEW_K_NOR gNEW_POLARISER
    global gNEW_STRAINRET gNEW_ARREST
    global gNEW_NUMRESERVEDMGENS

    global gOLD_MorphogenNames
    global gNEW_MorphogenNames
    global gDefaultPlotOptions
    global gPlotOptionNames
    global gPlotPriorities gABfields
    global gGlobalProps
    global gPerNodeMgenDefaults gPerMgenDefaults
    global gAxisNames
    global gMISC_GLOBALS
    global findFEMCellStats

    global gDYNAMICFIELDS gSTATICFIELDS gHYBRIDFIELDS gUNSAVEDFIELDS gTRANSIENTFIELDS
    
    findFEMCellStats = zeros(1,7);
    
    % Every field of a mesh structure should appear in exactly one of
    % gDYNAMICFIELDS, gSTATICFIELDS, gHYBRIDFIELDS, or gUNSAVEDFIELDS.
    gTRANSIENTFIELDS = { ...
            ... % These fields may or may not be present in a mesh.
            'strainhandles', ...
            'displacementhandles', ...
            'plothandles', ...
            'normalhandles', ...
            'visible', ...
            'timeForIter', ...
            'ticForIter', ...
            'borders', ... % Really optional, not transient.
        };

    gUNSAVEDFIELDS = { ...
            ... % These fields should not be saved in mesh files.
            'interactionMode', ...
            'saved', ...
            'stop', ...
            'rewriteIFneeded', ...
            'pictures', ...
            'selection', ...
        };
    gHYBRIDFIELDS = { ...
            ... % These fields should be saved in both the static and dynamic mesh files.
            'mgenIndexToName', ...
            'mgenNameToIndex', ...
        };
    gDYNAMICFIELDS = { ...
            ... % These fields should be saved in the dynamic mesh file only.
            'globalDynamicProps', ...
            'nodes', ...
            'prismnodes', ...
            'tricellvxs', ...
            'edgeends', ...
            'edgecells', ...
            'celledges', ...
            'seams', ...
            'nodecelledges', ...
            'currentbendangle', ...
            'initialbendangle', ...
            'displacements', ...
            'scripthistory', ...
            'growthanglepervertex', ...
            'growthangleperFE', ...
            'morphogens', ...
            'morphogenclamp', ...
            'mgen_production', ...
            'mutantLevel', ...
            'mgenswitch', ...
            'transportfield', ...
            'fixedDFmap', ...
            'gradpolgrowth', ...
            'polfreeze', ...
            'polfreezebc', ...
            'polfrozen', ...
            'effectiveGrowthTensor', ...
            'celldata', ...
            'cellFrames', ...
            'cellareas', ...
            'unitcellnormals', ...
            'versioninfo', ...
            'secondlayer', ...
            'cellstiffness', ...
            'cellbulkmodulus', ...
            'cellpoisson', ...
            'decorFEs', ...
            'decorBCs', ...
            'drivennodes', ...
            'drivenpositions', ...
            'visible', ...
            'outputs', ...
            'plotdata', ...
            'userdata', ...
            'waypoints', ...
            'moviescripts' ...
            'movieselected', ...
        };
    gSTATICFIELDS = { ...
            ... % These fields should be saved in the static mesh file.
            'globalProps', ...
            'stagetimes', ...
            'plotdefaults', ...
            'mgen_interpType', ...
            'mgen_absorption', ...
            'mgen_dilution', ...
            'mgen_transportable', ...
            'mgen_plotpriority', ...
            'mgen_plotthreshold', ...
            'mgenposcolors', ...
            'mgennegcolors', ...
            'outputcolors', ...
            'absKvector', ...
            'allMutantEnabled', ...
            'meshparams', ...
        };

    global gFULLSTATICFIELDS
    % These are the fields that are saved in a project's static file.
    gFULLSTATICFIELDS = [ gSTATICFIELDS gHYBRIDFIELDS ];

    outputPlotQuantities = { 'resultantgrowth', ...
                             'resultantanisotropy', ...
                             'resultantbend', ...
                             'residualgrowth', ...
                             'residualanisotropy', ...
                             'residualbend', ...
                             'specifiedgrowth', ...
                             'specifiedanisotropy', ...
                             'specifiedbend', ...
                             'rotation' };
    numOutputPlotQuantities = length(outputPlotQuantities);
    obsoletePlotQuantities = { 'currentgrowth', ...
                               'currentbend', ...
                               'strain', ...
                               'stress', ...
                               'polarisation' };
    for i=1:numOutputPlotQuantities
        gOutputColors.(outputPlotQuantities{i}) = ...
            HSVtoRGB( [ (i-1)/7, 1, 1 ] );
    end
    for i=1:length(obsoletePlotQuantities)
        gOutputColors.(obsoletePlotQuantities{i}) = ...
            HSVtoRGB( [ (i-1)/7, 1, 1 ] );
    end

    global gDEFAULTFIELDS
    gDEFAULTFIELDS = struct( ...
        'stagetimes', [], ...
        'secondlayer', struct(), ...
        'meshparams', struct(), ...
        'cellFrames', [], ...
        'growthanglepervertex', [], ...
        'growthangleperFE', [], ...
        'decorFEs', [], ...
        'decorBCs', [], ...
        'outputcolors', gOutputColors, ...
        'visible', [], ...
        'plotdata', [] );

    global gOBSOLETEFIELDS
    gOBSOLETEFIELDS = { ...
        'stagenames', ...
        'gradpolbend', ...
        'stepsSinceCheckpoint', ...
        'initialArea', ...
        'vertexcolors', ...
        'facecolors', ...
        'thirdlayer' };

    global gXI gETA gZETA;
    onesixth = 1/6;
    twothirds = 2/3;
    sqrtthird = sqrt(1/3);
    gXI = [ onesixth, twothirds, onesixth, onesixth, twothirds, onesixth ];
    gETA = [ onesixth, onesixth, twothirds, onesixth, onesixth, twothirds ];
    gZETA = [ -sqrtthird, -sqrtthird, -sqrtthird, sqrtthird, sqrtthird, sqrtthird ];
    
    gMIN_MESHVERSION = 0;
    gMAX_MESHVERSION = 0;
    
    gMIN_MGENVERSION = 0;
    gMAX_MGENVERSION = 1;
    
    gOLD_K_PAR = 1; 
    gOLD_K_PER = 2;
    gOLD_K_POL = 3;
    gOLD_BEND_PAR = 4;
    gOLD_BEND_PER = 5;
    gOLD_BEND_POL = 6;
    gOLD_ARREST = 7;
    gOLD_STRAINRET = 8;
    gOLD_THICKNESS = 9;
    gOLD_NUMRESERVEDMGENS = 9;
    
%    gNEW_K_PAR = 1;
%    gNEW_K_PER = 2;
%    gNEW_K_NOR = 3;
%    gNEW_POLARISER = 4;
%    gNEW_A_PAR = 5;
%    gNEW_A_PER = 6;
%    gNEW_B_PAR = 7;
%    gNEW_B_PER = 8;
%    gNEW_STRAINRET = 9;
%    gNEW_ARREST = 10;
%    gNEW_NUMRESERVEDMGENS = 10;

    gNEW_KA_PAR = 1;
    gNEW_KA_PER = 2;
    gNEW_KB_PAR = 3;
    gNEW_KB_PER = 4;
    gNEW_K_NOR = 5;
    gNEW_POLARISER = 6;
    gNEW_STRAINRET = 7;
    gNEW_ARREST = 8;
    gNEW_NUMRESERVEDMGENS = 8;

    gMISC_GLOBALS = struct( ...
        'stagesuffixlength', 6, ...
        'stageprefix', '_s' );

    gOLD_MorphogenNames = upper( { ...
        'kpar', 'kperp', 'polariser', ...
        'bpar', 'bperp', 'NOTUSED', ...
        'arrest', 'strainret', 'thickness' } );
%{
    gNEW_MorphogenNames = { ...
        'KPAR', 'KPER', 'KNOR', 'POLARISER', ...
        'APAR', 'APER', 'BPAR', 'BPER', ...
        'STRAINRET', 'ARREST' };
%}
    gNEW_MorphogenNames = { ...
        'KAPAR', 'KAPER', 'KBPAR', 'KBPER', ...
        'KNOR', 'POLARISER', 'STRAINRET', 'ARREST' };

    gAxisNames = struct( 'total', [1 2 3], ...
                         'areal', [1 2], ...
                         'major', 1, ...
                         'minor', 2, ...
                         'parallel', 1, ...
                         'perpendicular', 2, ...
                         'normal', 3 );

    definePropertyLists();

    gPlotPriorities = { 'pervertex', 'perelement', 'tensor', 'morphogen', 'outputquantity', 'blank' };
    gABfields = [ gPlotPriorities, ...
        { 'outputaxes', 'perelementaxes', 'perelementcomponents', ...
          'axesquantity', 'axesdrawn', ... % These appear to be unused.
          'defaultmultiplot' } ];
    for i=1:length(gABfields)
        fn = gABfields{i};
        gDefaultPlotOptions.(fn) = [];
        gDefaultPlotOptions.([fn,'A']) = [];
        gDefaultPlotOptions.([fn,'B']) = [];
    end
    gDefaultPlotOptions.morphogen = 'KAPAR';
    gPlotOptionNames = fieldnames( gDefaultPlotOptions );

    global gOBSOLETEPLOTOPTIONS
    gOBSOLETEPLOTOPTIONS = { ...
        'hfigure', ...
        'hpicture', ...
        'hpictureBackground', ...
        'hlegend', ...
        'hscalebar', ...
        'hcolorbar', ...
        'hcolortexthi', ...
        'hcolortextlo', ...
        'hmaxcolor', ...
        'hmincolor', ...
        'numbering', ...
        'showlabel', ...
        'plottensors', ...
        'plotmode', ...
        'plotquantity', ...
        'multicolor', ...
        'multimorphogen', ...
        'monochrome', ...
        'stuffPerVertex', ...
        'stuff', ...
        'vertexcolors', ...
        'tensordata', ...
        'facecolors', ...
        'rawcolors', ...
        'autoCentre', ...
        'showLeafSurface', ...
        'showMutant' ...
    };

    global gOBSOLETESTATICPROPS
    gOBSOLETESTATICPROPS = { ...
    	'legend', ...
    	'sparseK', ...
    	'jiggleProportion', ...
    	'cvtperiter', ...
    	'maxBioBcells' ...
    };

    gPerNodeMgenDefaults = struct( 'morphogens', 0, ...
                               'morphogenclamp', 0, ...
                               'mgen_production', 0 );

    gPerMgenDefaults = struct( 'mgen_absorption', 0, ...
                               'mutantLevel', 1, ...
                               'mgenswitch', 1, ...
                               'mgen_dilution', false, ...
                               'mgen_transportable', false, ...
                               'mgen_plotpriority', 0, ...
                               'mgen_plotthreshold', 0, ...
                               'absKvector', [0;0;0], ...
                               'mgenposcolors', [1;0;0], ...
                               'mgennegcolors', [0;1;1] );
    gPerMgenDefaults.mgen_interpType = {gGlobalProps.defaultinterp};

    createMeshParamInfo();
end


