function webify_interaction_function(filename)
    % function webify_interaction_function(filename)
    %
    % filename, interaction function filename including suffix
    %
    % J.Andrew Bangham 2011
    if nargin<1
        [FileName,PathName]=uigetfile('*.m','Select interaction function filename');
        filename=fullfile(PathName,FileName);
    end
    if filename
        newfilename=[filename(1:end-2),'.txt'];
        if exist(newfilename)==2
            delete(newfilename);
        end
        fid=fopen(filename,'r');
        newfid=fopen(newfilename,'a');
        if fid~=-1 && fid~=-1
            counter=1;
            while ~feof(fid)
                txt=fgetl(fid);
                % first insert section numbers in CornflowerBlue
                counter=txt_add_line(txt,fid,newfid,'function m',counter);
                counter=txt_add_line(txt,fid,newfid,'%%% USER CODE: INITIALISATION',counter);
                counter=txt_add_line(txt,fid,newfid,'%%% SECTION 1: ACCESSING MORPHOGENS AND TIME.',counter);
                counter=txt_add_line(txt,fid,newfid,'% alter the set of nodes.',counter);
                counter=txt_add_line(txt,fid,newfid,'% Second way to',counter);
                counter=txt_add_line(txt,fid,newfid,'% Directives for',counter);
                counter=txt_add_line(txt,fid,newfid,'% If you want to define different phases',counter);
                counter=txt_add_line(txt,fid,newfid,'% Code common to all models.',counter);
                counter=txt_add_line(txt,fid,newfid,'% Code for specific models.',counter);
                counter=txt_add_line(txt,fid,newfid,'% @@model MODEL1',counter);
                counter=txt_add_line(txt,fid,newfid,'% @@model MODEL2',counter);
                counter=txt_add_line(txt,fid,newfid,'%%% END OF USER CODE: MORPHOGEN INTERACTIONS',counter);
                counter=txt_add_line(txt,fid,newfid,'% If needed force FE to subdivide (increase number FE',counter);
                counter=txt_add_line(txt,fid,newfid,'function m = local_setproperties( m )',counter);
                counter=txt_add_line(txt,fid,newfid,'% Here you may write any functions',counter);
                % now make comments green
                ind=regexpi(txt,'%');
                if ~isempty(ind)
                    newtxt=[txt(1:ind-1),'<span style="color: Green">',txt(ind:end),'</span>'];
                else
                    newtxt=txt;
                end
                if newfid
                    fprintf(newfid,' %s\n',newtxt);
                end
            end
            fclose(fid);
            if newfid
                fclose(newfid);
            end
            disp(sprintf('Written %s',fullfile(pwd,newfilename)))
        else
            disp('Failed to open one or other file')
        end
    end
end
function counter=txt_add_line(txt,fid,newfid,lookfor_txt,counter)
    ind=regexpi(txt,lookfor_txt);
    outputtxt=sprintf('% Section %d',counter);
    if ~isempty(ind)
        newtxt=['<span style="color: CornflowerBlue">',outputtxt,'</span>'];
        if newfid
            fprintf(newfid,' %s\n',newtxt);
        end
        counter=counter+1;
    end
end
