function z = whichSide( n, p, v )
%z = whichSide( n, p, v )
%   Returns 1 or 0, depending on which side v is of
%   the hyperplane perpendicular to n through p.
%   n and p must be row vectors, and v a matrix of row vectors.
%   z will be a column vector of booleans.
    z = ((v - (ones(size(v,1),1) * p)) * n') > 0;
end
