function v = rotateVecAboutVec( v, a, theta )
%v = rotateVecAboutvec( v, a, theta )
%   Rotate the 3D vector v about the axis a by angle theta.  a is assumed
%   to be a unit vector.  v and a must be row vectors.  v and a can also be
%   N*3 matrices, and theta an N-element vector: each vector will be
%   rotated about the corresponding axis by the corresponding angle.

    w = cross( a, v, 2 );
    c = cos(theta);
    s = sin(theta);
    v = [ c.*v(:,1) + s.*w(:,1), c.*v(:,2) + s.*w(:,2), c.*v(:,3) + s.*w(:,3) ];
end
