function bc = randBaryCoords( n )
%bc = randBaryCoords
%   Return random barycentric coordinates yielding a uniform distribution
%   over a triangle.  n is the number of coordinate sets to return,
%   defaulting to 1.

    if nargin < 1, n = 1; end

    k = sqrt(rand(n,1));
    bc1 = 1-k;
    bc2 = rand(n,1) .* k;
    bc3 = 1 - bc1 - bc2;
    bc = [ bc1, bc2, bc3 ];
end
