function lightAxes( theaxes, turnLightOn )
%lightAxes( theaxes, turnLightOn )
%   Turn lighting for the given axes object on or off.
%   To turn the light off, every child object of type 'light' is deleted.
%   To turn it on, if there is already a child object of type 'light',
%   nothing is done.  Otherwise a light is created with default properties.

    c = get( theaxes, 'Children' );
    if turnLightOn
        for i=1:length(c)
            if strcmp( get(c(i),'Type'), 'light' )
                return;
            end
        end
        light( 'Parent', theaxes );
    else
        for i=1:length(c)
            if strcmp( get(c(i),'Type'), 'light' )
                delete(c(i));
            end
        end
    end
end
