function [rev,date] = GFtboxRevision()
%[rev,date] = GFtboxRevision()
%   Determine the revision number and date of the GFtbox code.

    whereami = fileparts(mfilename('fullpath'));
    codedirectory = fileparts(whereami);
    [rev,date] = svnrevision( codedirectory, false );
    rev = int32(rev);
    
    revisionFile = fullfile( codedirectory, 'GFtbox_version.txt' );
    haveRevFile = exist( revisionFile, 'file' );
    filerev = 0;
    if haveRevFile
        % Read version number.
        try
            fid = fopen( revisionFile, 'r' );
            s = fgetl( fid );
            fclose( fid );
            filerev = sscanf( s, '%d' );
            if isempty( filerev )
                filerev = 0;
            end
        catch
        end
    end
    if rev > filerev
        % Write version number.
        try
            fid = fopen( revisionFile, 'w' );
            fprintf( fid, '%d\n', rev );
            fclose( fid );
        catch
        end
    else
        rev = filerev;
    end
end
