function m = addToNormal( m, addn, absolute )
%m = addToNormal( m, addn, absolute )
%   addn is a vector containing one value per node of m.
%   If absolute is true, then each node is displaced normal to the surface
%   by that amount.  If absolute is false (the default), then each node is
%   displaced normal to the surface by that proportion of the thickness at
%   that point.

    if ~m.globalProps.prismnodesvalid
        complain( 'addToNormal: prisms are not valid.\n' );
        return;
    end
    if nargin < 3
        absolute = false;
    end
    if absolute
        delta = m.prismnodes(2:2:end,:) - m.prismnodes(1:2:end,:);
        thicknesses = sqrt(sum(delta.^2,2));
        perturbations = delta .* repmat( addn./thicknesses, 1, 3 );
    else
        perturbations = (m.prismnodes(2:2:end,:) - m.prismnodes(1:2:end,:)) ...
            .* repmat( addn(:), 1, 3 );
%     for i=1:size( m.nodes, 1 )
%         i2 = i+i;
%         i1 = i2-1;
%         perturbation = ...
%             (m.prismnodes(i2,:) - m.prismnodes(i1,:))*addn(i);
%         m.prismnodes([i1 i2],:) = m.prismnodes([i1 i2],:) ...
%             + [ perturbation; perturbation ];
%     end
    end
    m.prismnodes = m.prismnodes + ...
        reshape( repmat( perturbations', 2, 1 ), 3, [] )';
    m.globalProps.alwaysFlat = 0;
    m.globalProps.trinodesvalid = false;
    m = makeTRIvalid( m );
    m = recalc3d( m );
    m.initialbendangle = m.currentbendangle;
end
