function m = addToZ( m, addz )
    m.nodes(:,3) = m.nodes(:,3) + addz;
    m.saved = 0;
    if m.globalProps.prismnodesvalid
        m.prismnodes(:,3) = m.prismnodes(:,3) + ...
            reshape( [addz addz]', size(m.nodes,1)*2, 1 );
    else
        if ~m.prismsvalid
            complain( 'addToZ: prisms are not valid.\n' );
            return;
        end
    end
    m.globalProps.alwaysFlat = 0;
    m = recalc3d( m );
    m.initialbendangle = m.currentbendangle;
end
