function oldm = calcOldMorphogens( newm )
    NEW_KPAR = 1;
    NEW_KPER = 2;
    NEW_KNOR = 3;
    NEW_POLARISER = 4;
    NEW_APAR = 5;
    NEW_APER = 6;
    NEW_BPAR = 7;
    NEW_BPER = 8;
    NEW_STRAINRET = 9;
    NEW_ARREST = 10;

    apar = newm( :, NEW_KPAR ) .* newm( :, NEW_APAR );
    aper = newm( :, NEW_KPER ) .* newm( :, NEW_APER );
    bpar = newm( :, NEW_KPAR ) .* newm( :, NEW_BPAR );
    bper = newm( :, NEW_KPER ) .* newm( :, NEW_BPER );
    oldm.kpar = (apar+bpar)/2;
    oldm.kper = (aper+bper)/2;
    oldm.bpar = (apar-bpar)/2;
    oldm.bper = (aper-bper)/2;
    oldm = [ ...
        (apar+bpar)/2, ...
        (aper+bper)/2, ...
        newm( :, NEW_POLARISER ), ...
        (apar-bpar)/2, ...
        (aper-bper)/2, ...
        newm( :, NEW_POLARISER ), ...
        newm( :, NEW_ARREST ), ...
        newm( :, NEW_STRAINRET ), ...
        newm( :, NEW_KNOR ) ];
end
