function [m,ok] = leaf_flatten( m, varargin )
%[m,ok] = leaf_flatten( m )
%   Flatten each of the connected components of m.
%
%   Options:
%       interactive: If true (default is false), then the flattening will
%                    be carried out interactively.  The user can skip the
%                    flattening of components that appear not to be well
%                    flattenable, or cancel the whole operation.
%       method:      One of the following:
%                       'laplacian'
%                       'geodesic'
%                       'ballandspring'
%
%   Topics: Mesh editing.

    if isempty(m), return; end
    [s,ok] = safemakestruct( mfilename(), varargin );
    if ~ok, return; end
    s = defaultfields( s, 'interactive', false, 'method', 'ballandspring' );
    ok = checkcommandargs( mfilename(), s, 'exact', ...
        'interactive', 'method' );
    if ~ok, return; end

    [m,ok] = flattenComponents( m, s.interactive, s.method );
end
