function m = leaf_lune( m, varargin )
%m = leaf_lune( m, ... )
%   NOT IMPLEMENTED.
%   Create a new mesh in the shape of a stereotypical leaf, oval with
%   pointed ends.
%
%   Arguments:
%       M is either empty or an existing mesh.  If it is empty, then an
%       entirely new mesh is created, with the default set of morphogens
%       If M is an existing mesh, then its geometry is replaced by the new
%       mesh.  It retains the same set of morphogens (all set to zero
%       everywhere on the new mesh), interaction function, and all other
%       properties not depending on the specific geometry of the mesh.
%
%   Options:
%       'xwidth'        The diameter in the X dimension.  Default 3.
%       'ywidth'        The diameter in the Y dimension.  Default 2.
%       'xdivs'         The number of segments to divide it into along the
%                       X axis.  Default 8.
%   Example:
%       m = leaf_lune( [], 'xwidth', 3, 'ywidth', 2, 'xdivs', 8 );
%
%   See also: LEAF_CIRCLE, LEAF_CYLINDER, LEAF_ONECELL,
%   LEAF_RECTANGLE, LEAF_SEMICIRCLE, LEAF_LOBES.
%
%   Equivalent GUI operation: selecting "Leaf" in the pulldown menu in the
%   "Mesh editor" panel and clicking the "Generate mesh" button.
%
%   Topics: UNIMPLEMENTED, Mesh creation.

    [s,ok] = safemakestruct( mfilename(), varargin );
    if ~ok, return; end
    setGlobals();
    global gMAX_MGENVERSION
    s = defaultfields( s, 'xwidth', 3, 'ywidth', 2, 'xdivs', 8, ...
        'version', gMAX_MGENVERSION );
    ok = checkcommandargs( 'leaf_leafmesh', s, 'only', ...
        'xwidth', 'ywidth', 'xdivs', 'version' );
    if ~ok, m = []; return; end
    
    complain( '%s: not implemented.\n', mfilename() );
    return;
    
    newm = leafmesh( s.xwidth, s.ywidth, s.xdivs );
    m = setmeshfromnodes( newm, m, s.version );
    m.meshparams = s;
    m.meshparams.randomness = 0;
    m.meshparams.type = regexprep( mfilename(), '^leaf_', '' );
end

