function m = leaf_mgen_linear( m, varargin )
%m = leaf_mgen_linear( m, morphogen, amount, ... )
%   Set the value of a specified morphogen to a linear gradient.
%
%   Arguments:
%       1: The name or index of a morphogen.
%       2: The maximum amount of morphogen to add to every node.
%
%   Options:
%       'direction'     Either a single number (the angle in degrees
%                       between  the gradient vector and the X axis, the
%                       gradient vector lying in the XY plane; or a triple
%                       of numbers, being a vector in the direction of the
%                       gradient.  The length of the vector does not
%                       matter.  Default is a gradient parallel to the
%                       positive X axis. 
%   Examples:
%       m = leaf_mgen_linear( m, 'growth', 1, 'direction', 0 );
%
%   See also: leaf_mgen_const.
%
%   Equivalent GUI operation: clicking the "Add linear" button in the
%   "Morphogens" panel.  The amount is specified by the "Amount" slider and
%   test item.  Direction is specified in degrees by the "Direction" text
%   box.
%
%   Topics: Morphogens.

    if isempty(m), return; end
    [ok1, morphogen, args] = getTypedArg( mfilename(), {'numeric','char'}, varargin );
    if ~ok1, return; end
    g = FindMorphogenIndex( m, morphogen, mfilename() );
    if isempty(g), return; end
    [ok2, amount, args] = getTypedArg( mfilename(), 'double', args );
    if ~ok2, return; end
    
    [s,ok] = safemakestruct( mfilename(), args );
    if ~ok, return; end
    s = defaultfields( s, 'direction', [1,0,0] );
    ok = checkcommandargs( mfilename(), s, 'exact', 'direction' );
    if ~ok, return; end
    if length(s.direction)==1
        s.direction = s.direction * pi/180;
    end
    
    for i=1:length(g)
        m = setlinearfield( m, amount, g(i), s.direction, 1 );
    end
end
