function m = convertABtoBEND( m )
    if m.versioninfo.mgenversion == 0;
        return;
    end

    global gOLD_NUMRESERVEDMGENS;

%   global gNEW_K_PAR gNEW_K_PER;
    global gNEW_K_NOR gNEW_POLARISER;
%   global gNEW_A_PAR gNEW_A_PER gNEW_B_PAR gNEW_B_PER;
    global gNEW_KA_PAR gNEW_KA_PER gNEW_KB_PAR gNEW_KB_PER;
    global gNEW_STRAINRET gNEW_ARREST gNEW_NUMRESERVEDMGENS;

    global gOLD_MorphogenNames

    [Kpar,Bendpar] = kbend_from_ab( ...
                        m.morphogens(:,gNEW_KA_PAR), ...
                        m.morphogens(:,gNEW_KB_PAR), ...
                        m.globalProps.allowNegativeGrowth );
    [Kper,Bendper] = kbend_from_ab( ...
                        m.morphogens(:,gNEW_KA_PER), ...
                        m.morphogens(:,gNEW_KB_PER), ...
                        m.globalProps.allowNegativeGrowth );
    
    oldmorphogens = [ ...
        Kpar, ...
        Kper, ...
        m.morphogens( :, gNEW_POLARISER ), ...
        Bendpar, ...
        Bendper, ...
        m.morphogens( :, gNEW_POLARISER ), ...
        m.morphogens( :, gNEW_ARREST ), ...
        m.morphogens( :, gNEW_STRAINRET ), ...
        m.morphogens( :, gNEW_K_NOR ) ];
    newUserMgenRange = (gNEW_NUMRESERVEDMGENS+1):size(m.morphogens,2);

    m.morphogens = [ oldmorphogens, m.morphogens( :, newUserMgenRange ) ];
    m.morphogenclamp = [ zeros(size(oldmorphogens)), m.morphogenclamp( :, newUserMgenRange ) ];
    m.mgen_absorption = [ zeros(1,gOLD_NUMRESERVEDMGENS), m.mgen_absorption( :, newUserMgenRange ) ];
    m.mgen_production = [ zeros(size(oldmorphogens),gOLD_NUMRESERVEDMGENS), m.mgen_production( :, newUserMgenRange ) ];
    m.mutantLevel = [ ones(1,gOLD_NUMRESERVEDMGENS), m.mutantLevel( :, newUserMgenRange ) ];
    m.mgenswitch = [ ones(1,gOLD_NUMRESERVEDMGENS), m.mgenswitch( :, newUserMgenRange ) ];
    new_mgen_interpType = cell( 1, gOLD_NUMRESERVEDMGENS );
    for i=1:gOLD_NUMRESERVEDMGENS
        new_mgen_interpType{i} = 'mid';
    end
    m.mgen_interpType = { new_mgen_interpType{:}, m.mgen_interpType{newUserMgenRange} };
    m.mgen_dilution = [ false(1,gOLD_NUMRESERVEDMGENS), ...
                        m.mgen_dilution( :, newUserMgenRange ) ];

%    old_absKvector = [ ...
%        m.absKvector( :, [ gNEW_K_PAR gNEW_K_PER gNEW_POLARISER ] ), ...
%        sum( m.absKvector( :, [ gNEW_A_PAR gNEW_B_PAR ] ), 2 )/2, ...
%        sum( m.absKvector( :, [ gNEW_A_PER gNEW_B_PER ] ), 2 )/2, ...
%        m.absKvector( :, [ gNEW_POLARISER gNEW_ARREST gNEW_STRAINRET gNEW_K_NOR ] ) ];

    % We take the diffusion constants for growth and bend to both equal the
    % average of the diffusion constants of A and B.  THis is why parKvec
    % and perKvec appear twice in old_absKvector.  So some information is
    % lost, but in practice the diffusion constants of all the standard
    % morphogens are almost always going to be zero anyway.
    parKvec = sum( m.absKvector( :, [ gNEW_KA_PAR gNEW_KB_PAR ] ), 2 )/2;
    perKvec = sum( m.absKvector( :, [ gNEW_KA_PER gNEW_KB_PER ] ), 2 )/2;
    old_absKvector = [ ...
        parKvec, perKvec, ...
        m.absKvector( :, gNEW_POLARISER ), ...
        parKvec, perKvec, ...
        m.absKvector( :, [ gNEW_POLARISER gNEW_ARREST gNEW_STRAINRET gNEW_K_NOR ] ) ];
    m.absKvector = [ old_absKvector, ...
                     m.absKvector( :, newUserMgenRange ) ];
    m.mgenIndexToName = { gOLD_MorphogenNames{:}, m.mgenIndexToName{newUserMgenRange} };
    m.mgenNameToIndex = invertDictionary( m.mgenIndexToName );
    
    m.versioninfo.mgenversion = 0;
    m = rewriteInteractionSkeleton( m, '', '', mfilename() );
end
