function m = diffusegrowth( m )
% m = diffusegrowth( m )    Perform one diffusion step for all the
% diffusible morphogens.  This includes decay and clamped values.
        
    minM = min(m.morphogens,[],1);
    maxM = max(m.morphogens,[],1);
    
    condScale = m.globalProps.lengthscale^2;
    fprintf( 1, 'diffusegrowth: lengthscale %.3f, condScale %.3f\n', ...
        m.globalProps.lengthscale, condScale );
    
    for i=1:size(m.morphogens,2)
        diffusible = any( m.absKvector(:,i) ~= 0 );
        transportable = m.mgen_transportable(i) && ~isempty( m.transportfield{i} );
        if diffusible || transportable
            fixedtemps = find( m.morphogenclamp(:,i) >= 1 );
            if diffusible
                if transportable
                    s = 'Diffusing/transporting';
                else
                    s = 'Diffusing';
                end
            else
                s = 'Transporting';
            end
            fprintf( 1, '%s %s (%.3g %.3g): ', ...
                     s, ...
                     m.mgenIndexToName{i}, ...
                     sqrt(m.absKvector(1,i)*m.absKvector(2,i)), ...
                     m.mgen_absorption(i) );
            newM = tempdiff( ...
                m.nodes, ...
                m.tricellvxs, ...
                m.absKvector(:,i), ...
                m.mgen_absorption(i), ...
                m.mgen_production(:,i), ...
                m.morphogens(:,i), ...
                m.transportfield{i}, ... % transportvectors( m, i ), ...
                m.globalProps.timestep, ...
                m.globalProps.lengthscale, ...
                fixedtemps, ...
                m.cellareas, ...
                m.globalProps.diffusiontolerance, ...
                m.globalProps.solvertolerancemethod, ...
                m.globalProps.maxsolvetime, ...
                m );
            m.morphogens(m.morphogenclamp(:,i)==0,i) = ...
                newM(m.morphogenclamp(:,i)==0);
        end
    end
    if false
        for i=1:length(minM)
            m.morphogens(:,i) = max(m.morphogens(:,i),minM(i));
            m.morphogens(:,i) = min(m.morphogens(:,i),maxM(i));
        end
    end

    m.saved = 0;
end
