function w = findPerpVector( v )
%w = findPerpVector( v )  Returns a unit vector perpendicular to v.
%   v can be a row vector of length 3 or an N*3 matrix of row vectors.

    w = zeros(size(v));
    for i=1:size(v,1)
        if all(v(i,:)==0)
            w(i,:) = [ 0, 0, 0 ];
        else
            u = [ 1, 0, 0 ];
            w(i,:) = crossproc2( v(i,:), u );
            if ~any(w(i,:))
                u = [ 0, 1, 0 ];
                w(i,:) = crossproc2( v(i,:), u );
            end
        end
    end
    w = normvecs(w);
end
