function m = generateCellData( m, cis )
%m = generateCellData( m, cis )
%   Create the per-cell data structures for the cells listed in cis.  The
%   mesh and its globalProps are assumed to have already been computed.
%   If cis is omitted it defaults to all the cells.

    if nargin < 2
        cis = 1:size(m.tricellvxs,1);
    end
    if isempty(cis)
        return;
    end

    numGaussPoints = size(m.globalProps.gaussInfo.points,2);
    newcelldata(max(cis),1) = fecell( m );
    for cii=1:length(cis)
        ci = cis(cii);
        newcelldata(cii,1) = fecell( m );
        trivxs = m.tricellvxs(ci,:);
        prismvxs = [ trivxs*2-1, trivxs*2 ];
        cellvxCoords = m.prismnodes( prismvxs, : )';
        for i=1:numGaussPoints
            J = PrismJacobian( cellvxCoords, m.globalProps.gaussInfo.points(:,i) );
            newcelldata(cii).gnGlobal(:,:,i) = ...
                inv(J)' * m.globalProps.gaussInfo.gradN(:,:,i);
        end
        m.cellFrames(:,:,ci) = ...
            getCellFrame( m.unitcellnormals(ci,:), m.gradpolgrowth(ci,:) );
    end
    m.celldata(cis) = newcelldata;
  % m = recalc3d( m );  % WHY?
end
