function importRemoteStagesItem_Callback(hObject, eventdata)
    handles = guidata( hObject );
    if isempty(handles.mesh)
        return;
    end
    if isempty(handles.mesh.globalProps.projectdir)
        fprintf( 1, 'The mesh does not belong to a project.\n' );
        return;
    end
    [s,name,desc] = MoveStagesToProject( getModelDir(handles.mesh) );
    % MoveStagesToProject writes its own error messages.
    if ~isempty(s)
        reloadMesh( handles, 'reload' );
        handles = guidata( hObject );
        handles.mesh.globalProps.savedrunname = name;
        handles.mesh.globalProps.savedrundesc = desc;
        guidata( hObject, handles );
        setMeshFigureTitle( handles.output, handles.mesh );
    end

