function makeMultiplotWindow( handles )
    % make new figure of suitable size
    greenBack = [0.4 0.8 0.4];
  % greenFore = [0.9 1 0.9];
    screenpos = get(0,'ScreenSize'); % MonitorPositions?
    margins = [10,40,910,95];
    figurepos = screenpos + [margins(1),margins(2),-margins(1)-margins(3),-margins(2)-margins(4)];
    multiFigure = figure( 'IntegerHandle', 'off', ...
                          'NumberTitle', 'off', ...
                          'Name', 'Multiplot', ...
                          'Position', figurepos, ...
                          'Units', 'pixels', ...
                          'UserData', handles, ...
                          'Color', greenBack );
   
    numMgens = size(handles.mesh.morphogens,2);
    leftmargin = 20;
    topmargin = 20;
    rowheight = 20;
    rowspacing = 4;
    itemspacing = 10;
    chboxwidth = 150;
    pickerwidth = rowheight;
    goButtonHeight = 25;
    goButtonWidth = 100;
    negpicker_x = leftmargin + chboxwidth + itemspacing;
    pospicker_x = negpicker_x + pickerwidth;
    pickernameheight = 24;
    cur_x = negpicker_x;
    cur_y = figurepos(4) - topmargin - pickernameheight;
    uicontrol( multiFigure, ...
        'Style', 'text', ...
        'Units', 'pixels', ...
        'Position', [cur_x, cur_y, pickerwidth, pickernameheight], ...
        'Tag', '', ...
        'String', '-', ...
        'BackgroundColor', greenBack, ...
        'FontSize', 18, ...
        'FontWeight', 'bold', ...
        'HorizontalAlignment', 'center', ...
        'Visible', 'on' ...
    );
    cur_x = pospicker_x;
    uicontrol( multiFigure, ...
        'Style', 'text', ...
        'Units', 'pixels', ...
        'Position', [cur_x, cur_y, pickerwidth, pickernameheight], ...
        'Tag', '', ...
        'String', '+', ...
        'BackgroundColor', greenBack, ...
        'FontSize', 18, ...
        'FontWeight', 'bold', ...
        'HorizontalAlignment', 'center', ...
        'Visible', 'on' ...
    );
    cur_y = cur_y - rowspacing;
    for i=1:numMgens
        cur_x = leftmargin;
        cur_y = cur_y - rowheight;
        mgenName = handles.mesh.mgenIndexToName{i};
        uicontrol( multiFigure, ...
            'Style', 'checkbox', ...
            'Units', 'pixels', ...
            'Position', [cur_x, cur_y, chboxwidth, rowheight], ...
            'Tag', [mgenName '_CBOX'], ...
            'String', mgenName, ...
            'BackgroundColor', greenBack, ...
            'FontSize', 10, ...
            'Visible', 'on' ...
        );
        cur_x = negpicker_x;
        % panel
        uipanel( 'Parent', multiFigure, ...
            'Tag', [ mgenName '_NEGPICK'], ...
            'Units', 'pixels', ...
            'Position', [cur_x, cur_y, pickerwidth, rowheight], ...
            ... % 'HighlightColor', [0 1 0], ...
            ... % 'ShadowColor', [0 0 1], ...
            ... % 'ForegroundColor', [1 0 0], ...
            'BackgroundColor', [1 1 1], ...
            'Visible', 'on', ...
            'ButtonDownFcn', 'bgColorPick(gcbo,''Color'');' );
        cur_x = pospicker_x;
        hue = (i-1)/(2*pi);
        hue = hue - floor(hue);
        uipanel( 'Parent', multiFigure, ...
            'Tag', [ mgenName '_POSPICK'], ...
            'Units', 'pixels', ...
            'Position', [cur_x, cur_y, pickerwidth, rowheight], ...
            ... % 'HighlightColor', [0 1 0], ...
            ... % 'ShadowColor', [0 0 1], ...
            ... % 'ForegroundColor', [1 0 0], ...
            'BackgroundColor', hsv2rgb( [hue, 1, 1] ), ...
            'Visible', 'on', ...
            'ButtonDownFcn', 'bgColorPick(gcbo,''Color'');' );
        cur_y = cur_y - rowspacing;
    end
    cur_x = leftmargin;
    cur_y = cur_y - goButtonHeight;
    uicontrol( multiFigure, ...
        'Style', 'pushbutton', ...
        'Tag', 'makepicButton', ...
        'String', 'Make image', ...
        'FontSize', 10, ...
        'Units', 'pixels', ...
        'Position', [cur_x, cur_y, goButtonWidth, goButtonHeight], ...
        'Callback', @clicked...
    );
    guidata( multiFigure, guihandles(multiFigure) );
    
    % for each morphogen, insert controls
    % Name, checkbox, two color pickers, slider/text for hash angle,
    % slider/text for hash width %.  The sliders should give a live
    % preview.
    
    % create a square axes filling the remaining space
    
    % Callbacks:
    %  Color pickers use bgColorPick for ButtonDownFcn
    %  Morphogen checkboxes have empty callback
    %  Slider/texts recreate the hash mask and redisplay it
    %  Button to compose new picture:
    %   This needs to plot each morphogen in turn in the main window (first
    %   bringing it to the front), with axes off and monochrome on, and
    %   capture the image.  Then combine the images and display.
    
end

function clicked( hObject, eventData )
    fprintf( 1, 'clicked: %d args\n', nargin );
    hObject
    eventData
    multiplotHandles = guidata( hObject );
    toolboxHandles = get( get( hObject, 'Parent' ), 'UserData' );
    if isempty( toolboxHandles.mesh ), return; end
    numMgens = size( toolboxHandles.mesh.morphogens, 2 );
    for i=1:numMgens
        mgenName = toolboxHandles.mesh.mgenIndexToName{i};
        [cbox,colors] = getMgenParams( mgenName, multiplotHandles );
        if cbox
            leaf_plot( toolboxHandles.mesh, ...
                'morphogen', i, ...
                'cmaptype', 'monochrome', ...
                'monocolors', colors );
            % grab image
        end
    end
end

function [cbox,colors] = getMgenParams( mgenName, multiplotHandles )
    cbox = 0;
    colors = [];
    checkboxName = [ mgenName, '_CBOX' ];
    try
        cboxHandle = multiplotHandles.(checkboxName);
    catch
        fprintf( 1, 'Mesh has morphogen "%s", but no corresponding checkbox "%s" in Multiplot window.\n', ...
            mgenName, checkboxName );
        return;
    end
    cbox = get( cboxHandle, 'Value' );

    negpickName = [ mgenName, '_NEGPICK' ];
    try
        negpickHandle = multiplotHandles.(negpickName);
    catch
        fprintf( 1, 'Mesh has morphogen "%s", but no corresponding color picker "%s" in Multiplot window.\n', ...
            mgenName, negpickName );
        return;
    end
    negcolor = get( negpickHandle, 'BackgroundColor' );

    pospickName = [ mgenName, '_POSPICK' ];
    try
        pospickHandle = multiplotHandles.(pospickName);
    catch
        fprintf( 1, 'Mesh has morphogen "%s", but no corresponding color picker "%s" in Multiplot window.\n', ...
            mgenName, pospickName );
        return;
    end
    poscolor = get( pospickHandle, 'BackgroundColor' );
    
    colors = [ negcolor; poscolor ];
end
