function g = mgenCellGradient( m, mgen, cis )
%g = mgenCellGradient( m, mgen, cis )
%   For a mesh m, and morphogen field mgen defined at each vertex of m,
%   compute the gradient of mgen for each cell.  mgen can be either a
%   morphogen index, a morphogen name, or a row or column vector of values,
%   one for each vertex.  This is calculated in the global frame.

    if (numel(mgen)==1) || ischar(mgen)
        mgen = FindMorphogenIndex( m, mgen );
        if isempty(mgen)
            return;
        end
        mgen = m.morphogens( :, mgen );
    end
    if nargin < 3
        cis = 1:size(m.tricellvxs,1);
    end
    numcells = length(cis);
    g = zeros( numcells, 3 );
    for i=1:numcells
        ci = cis(i);
        vxs = m.tricellvxs(ci,:);
        g(i,:) = -trianglegradient( m.nodes( vxs, : ), mgen(vxs) );
    end
end

