function [basename,stagestring,stagetime] = parseStageFileName( sfn )
% Take a file name without extension, and look for a stage file suffix.
% If there is none, return basename as the original name, stagestring as
% empty, and stagetime as zero.  Otherwise, return the stage segment as a
% string in stagestring (without the leading '_s'), and the corresponding
% real number in stagetime.  If the suffix fails to parse as a number,
% return stagestring as -1 and stagetime as zero.
    global gMISC_GLOBALS
    tokens = regexp( sfn, ['^(.*)', gMISC_GLOBALS.stageprefix, '([mM]?[0-9]+([dD][0-9]+)?)$'], 'tokens' );
    if (length(tokens)==1) && (length(tokens{1})==2)
        basename = tokens{1}{1};
        numstring = tokens{1}{2};
        stagestring = [gMISC_GLOBALS.stageprefix, numstring];
        numstring = regexprep( numstring, '[mM]', '-' );
        numstring = regexprep( numstring, '[dD]', '.' );
        [stagetime,count] = sscanf( numstring, '%f', 1 );
        if count ~= 1
            stagestring = -1;
            stagetime = 0;
        end
    else
        basename = sfn;
        stagestring = '';
        stagetime = 0;
    end
end
