function handles = plotGrowthCrosses( m, selcc, selbc, selpts, sparsedistance, ...
                                      arrows, crosses, equalsize, scale, s )
    global gOLD_K_PAR gOLD_K_PER
    global gNEW_KA_PAR gNEW_KA_PER gNEW_KB_PAR gNEW_KB_PER
    global gDefaultPlotOptions
    
    if nargin < 6
        scale = m.globalDynamicProps.cellscale;
    end
    if nargin < 7
        s = struct();
    end
    s = defaultFromStruct( s, gDefaultPlotOptions, ...
                           { 'arrowthickness', ...
                             'crossthickness', ...
                             'arrowheadsize', ...
                             'arrowheadratio', ...
                             'highgradcolor', ...
                             'lowgradcolor' } );
    
    THRESHOLDING = false;
    
    h = guidata( m.pictures(1) );
    theaxes = h.picture;

  % if maxCellGrowth==0
  %     return;
  % end

    quiverscale = scale*0.4;
  % quivermajorformat = { 'Color', [0 0 0.3], 'LineWidth', 2 };
  % quiverminorformat = { 'Color', [0 0 0.3], 'LineWidth', 1 };
    quivernoarrowtype = '-.';
    if arrows
        quiverarrowtype = '-';
    else
        quiverarrowtype = quivernoarrowtype;
    end
    
    % Find the cell centres.
  % cc = cellcentres( m, selcc );
    numselcells = length(selcc);
    
    % Find the unit gradient vectors and the cells with zero or low gradients.
    AVERAGING = true;
    if AVERAGING
        unitgrad = zeros( length(selcc), 3 );
        for i=1:length(selcc)
            unitgrad(i,:) = avpolgrad( m, selcc(i), selbc(i,:), selpts(i), sparsedistance );
        end
    else
        unitgrad = m.gradpolgrowth(selcc,:);
    end
    gradnorm = sqrt( sum( unitgrad.*unitgrad, 2 ) );
    zerograd = gradnorm==0;
    lowgrad = m.polfrozen(:); % gradnorm < m.globalProps.mingradient;
    circles = false( numselcells, 1 );
    for sci=1:numselcells
        ci = selcc(sci);
        n = norm(unitgrad(sci,:));
        if n > 0
            unitgrad(sci,:) = unitgrad(sci,:)/n;
        else
            unitgrad(sci,:) = findunitperp( m.unitcellnormals(ci,:) );
            circles(sci) = true;
        end
    end
    if THRESHOLDING
        circles = circles | lowgrad;
    end

    if crosses
        % Find the unit vectors perpendicular to the gradients.
        crossgrad = cross( unitgrad, m.unitcellnormals(selcc,:), 2 );
    end

    majorlength = [];
    minorlength = [];
    if equalsize && ~crosses
        majorvec = unitgrad*quiverscale;
    else
        % Scale the vectors according to the magnitude of the
        % morphogen-specified growth.
        
        % First calculate the growth rates.
        if m.versioninfo.mgenversion==0
            k_mgens = [gOLD_K_PAR gOLD_K_PER];
            cellGrowth = sum( ...
                reshape( m.morphogens( m.tricellvxs(selcc,:)', k_mgens ), ...
                    3, [], 2 ), 1 ) / 3;
            clear k_mgens
        else
            ka_mgens = [gNEW_KA_PAR gNEW_KA_PER];
            cellGrowthA = sum( ...
                reshape( m.morphogens( m.tricellvxs(selcc,:)', ka_mgens ), ...
                    3, [], 2 ), 1 ) / 3;
            kb_mgens = [gNEW_KB_PAR gNEW_KB_PER];
            cellGrowthB = sum( ...
                reshape( m.morphogens( m.tricellvxs(selcc,:)', kb_mgens ), ...
                    3, [], 2 ), 1 ) / 3;
            cellGrowth = (cellGrowthA + cellGrowthB)/2;
            clear ka_mgens kb_mgens cellGrowthA cellGrowthB
        end
        cellGrowth = abs( reshape( cellGrowth, [], 2 ) );
        maxCellGrowth = max(cellGrowth(:));
        
        % Now scale by growth rate.
        majorlength = cellGrowth(:,1);
        if crosses
            minorlength = cellGrowth(:,2);
            if THRESHOLDING
                for i=find(circles)'
                    % When the gradient is low, growth is isotropic even if
                    % the par and perp values differ.
                    majorlength(i) = (majorlength(i) + minorlength(i))/2;
                    minorlength(i) = majorlength(i);
                end
            end
        end
        if equalsize
            maxLinGrowth = max(majorlength,minorlength);
            if maxLinGrowth > 0
                majorlength = majorlength./maxLinGrowth;
            end
        elseif maxCellGrowth > 0
            majorlength = majorlength/maxCellGrowth;
        end
        if crosses
            if equalsize
                if maxLinGrowth > 0
                    minorlength = minorlength./maxLinGrowth;
                end
            elseif maxCellGrowth > 0
                minorlength = minorlength/maxCellGrowth;
            end
        end
        majorlength = majorlength*quiverscale;
        if crosses
            minorlength = minorlength*quiverscale;
        end
        majorvec = zeros( numselcells, 3 );
        for i=1:3
            majorvec(:,i) = unitgrad(:,i) .* majorlength;
        end
        if crosses
            minorvec = zeros( numselcells, 3 );
            for i=1:3
                minorvec(:,i) = crossgrad(:,i) .* minorlength;
            end
        end
    end
  % if ~isempty(minorlength)
  %     majorlength(zerograd) = (majorlength(zerograd) + minorlength(zerograd))/2;
  %     minorlength(zerograd) = majorlength(zerograd);
  % end
    
% Now do the plotting.

    % Array to store all the plot handles in, one row for each cell.
    % Unused elements are set to -1, because this value is never a valid
    % handle.
    % For cells containing a circle, the first element holds a handle to
    % the lineseries that is used to approximate the circle.
    % For other cells the major axis is stored, in two halves, in elements 1
    % and 2, and the minor axis is stored in elements 3 and 4.
    handles = -ones(numselcells,4);
    
    % Draw the isotropic growth circles.
    if any(circles) && crosses
        circlecentres = selpts(circles,:);
        circlemajors = majorvec(circles,:);
        circleminors = minorvec(circles,:);
        h = plot3circle( ...
            circlecentres, circlemajors, circleminors, 12, ...
            quivernoarrowtype, ...
            'Parent', theaxes, ...
            'Color', s.highgradcolor, ...
            'LineWidth', s.arrowthickness );
        handles(circles,1) = h;
    end

    % Draw the major axes.
    if isempty(majorlength)
        havemajors = ~circles;
    else
        havemajors = (~circles) & (majorlength ~= 0);
    end
    sel_lowgrad = lowgrad(selcc(:));
    havemajorshigh = havemajors & ~sel_lowgrad;
    havemajorslow = havemajors & sel_lowgrad;
    if any(havemajorshigh)
        handles(havemajorshigh,1:3) = myquiver3( ...
             selpts(havemajorshigh,:), ...
             majorvec(havemajorshigh,:), ...
             m.unitcellnormals(selcc(havemajorshigh),:), ...
             s.arrowheadsize, s.arrowheadratio, 1, 1, ...
             'LineStyle', quiverarrowtype, ...
             'Parent', theaxes, ...
             'Color', s.highgradcolor, ...
             'LineWidth', s.arrowthickness );
    end
    if any(havemajorslow)
        handles(havemajorslow,1:3) = myquiver3( ...
             selpts(havemajorslow,:), ...
             majorvec(havemajorslow,:), ...
             m.unitcellnormals(selcc(havemajorslow),:), ...
             s.arrowheadsize, s.arrowheadratio, 1, 1, ...
             'LineStyle', quiverarrowtype, ...
             'Parent', theaxes, ...
             'Color', s.lowgradcolor, ...
             'LineWidth', s.arrowthickness );
    end
           
    if crosses
        haveminors = (~circles) & (minorlength ~= 0);
        haveminorshigh = haveminors & ~lowgrad;
        haveminorslow = haveminors & lowgrad;
        if any(haveminorshigh)
            % Draw the minor axes.
            handles(haveminorshigh,4) = myquiver3( ...
                selpts(haveminorshigh,:), ...
                minorvec(haveminorshigh,:), ...
                m.unitcellnormals(selcc(haveminorshigh),:), ...
                0, 0, 1, 1, ...
                'LineStyle', quiverarrowtype, ...
            'Parent', theaxes, ...
            'Color', s.highgradcolor, ...
            'LineWidth', s.crossthickness );
        end
        if any(haveminorslow)
            % Draw the minor axes.
            handles(haveminorslow,4) = myquiver3( ...
                selpts(haveminorslow,:), ...
                minorvec(haveminorslow,:), ...
                m.unitcellnormals(selcc(haveminorslow),:), ...
                0, 0, 1, 1, ...
                'LineStyle', quiverarrowtype, ...
            'Parent', theaxes, ...
            'Color', s.lowgradcolor, ...
            'LineWidth', s.crossthickness );
        end
    end
end
