function p = plotadj( mesh, vels, force )
%PLOTADJ( MESH, VELS, FORCE ) Draw vertexes and edges of a graph.
%  PTS is a 2*n matrix containing the X and Y components
%  of the vertexes of the graph.
%  ADJ is the adjacency matrix: when ADJ(a,b) is nonzero,
%  a line will be drawn from [X(a),Y(a)] to [X(b),Y(b)].
%  The result is a plot structure.
n = size(mesh.nodes,1);
ln = 0;
xs = [ mesh.nodes(mesh.edgeends(:,1),1);
       mesh.nodes(mesh.edgeends(:,2),1) ];
ys = [ mesh.nodes(mesh.edgeends(:,1),2);
       mesh.nodes(mesh.edgeends(:,2),2) ];
zs = [ mesh.nodes(mesh.edgeends(:,1),3);
       mesh.nodes(mesh.edgeends(:,2),3) ];
hold on;
p = plot3( xs, ys, zs,'EraseMode','background' );
%scatter3( mesh.nodes(:,1), mesh.nodes(:,2), mesh.nodes(:,3) );
lo = min(min( mesh.nodes(1:3,:) ) );
hi = max(max( mesh.nodes(1:3,:) ) );
if (lo >= hi)
    lo = lo-1;
    hi = hi-1;
end
hold off
lo = -2; hi = 2;
axis( [ lo, hi, lo, hi, lo, hi ] )
grid on
axis square
end
